# log_parser.pl
# Functions for parsing this module's logs

do 'squid-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p) = @_;
$object = &html_escape($object);
if ($type eq 'acl') {
	return &text("log_acl_$action", "<tt>$object</tt>");
	}
elsif ($type eq 'host') {
	return &text("log_host_$action", "<tt>$object</tt>");
	}
elsif ($type eq 'http' || $type eq 'icp' ||
       $type eq 'always' || $type eq 'never' ||
       $type eq 'pool' || $type eq 'delay') {
	return &text("log_${type}_${action}",
		     "<tt>".&html_escape($object)."</tt>");
	}
elsif ($type eq 'user') {
	return &text("log_user_$action", "<tt>$object</tt>");
	}
elsif ($text{"log_$action"}) {
	return $text{"log_$action"};
	}
else {
	return undef;
	}
}

