#!/usr/local/bin/perl
# index.cgi
# Display all existing SSL tunnels

require './stunnel-lib.pl';

# Check if stunnel is installed
if (!-x $config{'stunnel_path'}) {
	&header($text{'index_title'}, "", "intro", 1, 1);
	print "<hr>\n";
	print &text('index_estunnel', "<tt>$config{'stunnel_path'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if inetd or xinetd is installed
if (!$has_inetd && !$has_xinetd) {
	&header($text{'index_title'}, "", "intro", 1, 1);
	print "<hr>\n";
	print "$text{'index_einetd'}<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Get the version
$ver = &get_stunnel_version(\$out);
&header($text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("stunnel", "man", "doc"), undef, undef,
	&text('index_version', $ver));
print "<hr>\n";
#if ($ver >= 4) {
#	print "<p>",&text('index_eversion', $ver, 4.0),"<p>\n";
#	print "<hr>\n";
#	&footer("/", $text{'index'});
#	exit;
#	}

# List all tunnels currently setup in inetd
@tunnels = &list_stunnels();
if (@tunnels) {
	print "<a href='edit_stunnel.cgi?new=1'>$text{'index_add'}</a> <br>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
	      "<td><b>$text{'index_port'}</b></td> ",
	      "<td><b>$text{'index_active'}</b></td> ",
	      "<td><b>$text{'index_action'}</b></td> </tr>\n";
	foreach $t (@tunnels) {
		print "<tr $cb>\n";
		if ($ver > 4) {
			# Parse new-style stunnel config file
			if ($t->{'args'} =~ /^(\S+)\s+(\S+)/) {
				$cfile = $2;
				@conf = &get_stunnel_config($cfile);
				($conf) = grep { !$_->{'name'} } @conf;
				}
			}
		print "<td>";
		if ($ver > 4 && !$cfile) {
			print &html_escape($t->{'name'});
			}
		else {
			print "<a href='edit_stunnel.cgi?idx=$t->{'index'}'>",
			      &html_escape($t->{'name'}),"</a>";
			}
		print "</td>\n";
		print "<td>",&html_escape($t->{'port'}),"</td>\n";
		if ($t->{'active'}) {
			print "<td>$text{'yes'}</td>\n";
			}
		else {
			print "<td><font color=#ff0000>$text{'no'}",
			      "</font></td>\n";
			}
		if ($ver > 4) {
			# Parse new-style stunnel config file
			if ($exec = $conf->{'values'}->{'exec'}) {
				$args = $conf->{'values'}->{'execargs'};
				print "<td>",&text('index_cmd',
				    $args ? "<tt>".&html_escape($args)."</tt>"
				          : "<tt>".&html_escape($exec)."</tt>"),
				      "</td>\n";
				}
			elsif ($conn = $conf->{'values'}->{'connect'}) {
				print "<td>",&text('index_remote',
				    "<tt>".&html_escape($conn)."</tt>"),"</td>\n";
				}
			elsif ($cfile) {
				print "<td>",&text('index_conf',
					"<tt>$cfile</tt>"),"</td>\n";
				}
			else {
				print "<td>$text{'index_noconf'}</td>\n";
				}
			}
		else {
			# Parse old-style stunnel args
			if ($t->{'args'} =~ /\s*-([lL])\s+(\S+)\s+--\s+(.*)/ ||
			    $t->{'args'} =~ /\s*-([lL])\s+(\S+)/) {
				print "<td>",&text('index_cmd',
				    $3 ? "<tt>".&html_escape($3)."</tt>"
				       : "<tt>".&html_escape($2)."</tt>"),
				      "</td>\n";
				}
			elsif ($t->{'args'} =~ /-r\s+(\S+):(\d+)/) {
				print "<td>",&text('index_remote',
				    "<tt>".&html_escape("$1:$2")."</tt>"),"</td>\n";
				}
			elsif ($t->{'args'} =~ /-r\s+(\d+)/) {
				print "<td>",&text('index_rport',
				    "<tt>".&html_escape($1)."</tt>"),"</td>\n";
				}
			else {
				print "<td><tt>",&html_escape($t->{'args'}),
				      "</tt></td>\n";
				}
			}
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<a href='edit_stunnel.cgi?new=1'>$text{'index_add'}</a> <p>\n";

print "<hr>\n";
print "<table width=100%><tr>\n";
print "<form action=apply.cgi>\n";
print "<td><input type=submit value='$text{'index_apply'}'></td>\n";
if ($has_inetd && $has_xinetd) {
	print "<td>$text{'index_applymsg1'}</td>\n";
	}
elsif ($has_inetd) {
	print "<td>$text{'index_applymsg2'}</td>\n";
	}
else {
	print "<td>$text{'index_applymsg3'}</td>\n";
	}
print "</form></tr></table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

