#!/usr/local/bin/perl
# list_received.cgi
# Display a list of received voicemail messages

require './vgetty-lib.pl';
&header($text{'received_title'}, "");
print "<hr>\n";

@conf = &get_config();
$dir = &receive_dir(\@conf);
opendir(DIR, $dir);
while($f = readdir(DIR)) {
	if ($f =~ /\.rmd$/) {
		local $info = &rmd_file_info("$dir/$f");
		push(@received, $info) if ($info);
		}
	}
closedir(DIR);

if (@received) {
	print "$text{'recieved_desc'}<p>\n";
	print "<form action=delete.cgi method=post>\n";
	print "<input type=hidden name=mode value=0>\n";
	print "<a href='' onClick='document.forms[0].del.checked = true; for(i=0; i<document.forms[0].del.length; i++) { document.forms[0].del[i].checked = true; } return false'>$text{'received_all'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[0].del.checked = !document.forms[0].del.checked; for(i=0; i<document.forms[0].del.length; i++) { document.forms[0].del[i].checked = !document.forms[0].del[i].checked; } return false'>$text{'received_invert'}</a>&nbsp;\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><br></td> ",
	      "<td><b>$text{'received_date'}</b></td> ",
	      "<td><b>$text{'received_size'}</b></td> ",
	      "<td><b>$text{'received_speed'}</b></td> ",
	      "<td><b>$text{'received_type'}</b></td> </tr>\n";
	foreach $r (sort { $b->{'date'} <=> $a->{'date'} } @received) {
		print "<tr $cb>\n";
		print "<td><input type=checkbox name=del ",
		      "value='$r->{'file'}'></td>\n";
		print "<td><a href='listen.cgi/voicemail.wav?file=",
		      &urlize($r->{'file'}),"&mode=0'>",
		      scalar(localtime($r->{'date'})),"</a></td>\n";
		print "<td>",int($r->{'size'}/1024)." kB","</td>\n";
		print "<td>$r->{'speed'}</td>\n";
		print "<td>",&text('pvfdesc', $r->{'type'}, $r->{'bits'}),
		      "</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	print "<a href='' onClick='document.forms[0].del.checked = true; for(i=0; i<document.forms[0].del.length; i++) { document.forms[0].del[i].checked = true; } return false'>$text{'received_all'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[0].del.checked = !document.forms[0].del.checked; for(i=0; i<document.forms[0].del.length; i++) { document.forms[0].del[i].checked = !document.forms[0].del[i].checked; } return false'>$text{'received_invert'}</a><p>\n";
	print "<input type=submit value='$text{'received_delete'}'>&nbsp;\n";
	print "<input type=submit name=move ",
	      "value='$text{'received_move'}'></form>\n";
	}
else {
	print "<p><b>$text{'received_none'}</b> <p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

