# solaris-lib.pl

# supported_filesystems()
# Returns a list of filesystem types on which dumping is supported
sub supported_filesystems
{
local @rv;
push(@rv, "ufs") if (&has_command("ufsdump"));
return @rv;
}

$multiple_directory_support = 1;

# dump_form(&dump)
sub dump_form
{
# Display common options
print "<tr> <td valign=top><b>",&hlink($text{'dump_dest'}, "dest"),
      "</b></td> <td colspan=3>\n";
printf "<input type=radio name=mode value=0 %s> %s\n",
	$_[0]->{'host'} ? '' : 'checked', $text{'dump_file'};
printf "<input name=file size=50 value='%s'> %s<br>\n",
	$_[0]->{'host'} ? '' : $_[0]->{'file'},
	&file_chooser_button("file");
printf "<input type=radio name=mode value=1 %s>\n",
	$_[0]->{'host'} ? 'checked' : '';
print &text('dump_host',
	    "<input name=host size=15 value='$_[0]->{'host'}'>",
	    "<input name=huser size=8 value='$_[0]->{'huser'}'>",
	    "<input name=hfile size=20 value='$_[0]->{'hfile'}'>"),
      "</td> </tr>\n";
}

sub dump_options_form
{
print "<tr> <td><b>",&hlink($text{'dump_update'},"update"),
      "</b></td>\n";
printf "<td><input name=update type=radio value=1 %s> %s\n",
	$_[0]->{'update'} ? 'checked' : '', $text{'yes'};
printf "<input name=update type=radio value=0 %s> %s</td>\n",
	$_[0]->{'update'} ? '' : 'checked', $text{'no'};

print "<td><b>",&hlink($text{'dump_verify'},"verify"),"</b></td>\n";
printf "<td><input name=verify type=radio value=1 %s> %s\n",
	$_[0]->{'verify'} ? 'checked' : '', $text{'yes'};
printf "<input name=verify type=radio value=0 %s> %s</td> </tr>\n",
	$_[0]->{'verify'} ? '' : 'checked', $text{'no'};

print "<tr> <td><b>",&hlink($text{'dump_level'},"level"),"</b></td>\n";
print "<td><select name=level>\n";
foreach $l (0 .. 9) {
	printf "<option value=%d %s>%d %s\n",
		$l, $_[0]->{'level'} == $l ? "selected" : "", $l,
		$text{'dump_level_'.$l};
	}
print "</select></td>\n";

print "<td><b>",&hlink($text{'dump_offline'},"offline"),"</b></td>\n";
printf "<td><input name=offline type=radio value=1 %s> %s\n",
	$_[0]->{'offline'} ? 'checked' : '', $text{'yes'};
printf "<input name=offline type=radio value=0 %s> %s</td> </tr>\n",
	$_[0]->{'offline'} ? '' : 'checked', $text{'no'};
}

# parse_dump(&dump)
sub parse_dump
{
# Parse common options
if ($in{'mode'} == 0) {
	$in{'file'} =~ /\S/ || &error($text{'dump_efile'});
	$_[0]->{'file'} = $in{'file'};
	delete($_[0]->{'host'});
	delete($_[0]->{'huser'});
	delete($_[0]->{'hfile'});
	}
else {
	gethostbyname($in{'host'}) || &check_ipaddress($in{'host'}) ||
		&error($text{'dump_ehost'});
	$_[0]->{'host'} = $in{'host'};
	$in{'huser'} =~ /^\S+$/ || &error($text{'dump_ehuser'});
	$_[0]->{'huser'} = $in{'huser'};
	$in{'hfile'} || &error($text{'dump_ehfile'});
	$_[0]->{'hfile'} = $in{'hfile'};
	delete($_[0]->{'file'});
	}

$_[0]->{'update'} = $in{'update'};
$_[0]->{'verify'} = $in{'verify'};
$_[0]->{'level'} = $in{'level'};
$_[0]->{'offline'} = $in{'offline'};
}

# execute_dump(&dump, filehandle, escape)
# Executes a dump and displays the output
sub execute_dump
{
local $fh = $_[1];
local $cmd = "ufsdump $_[0]->{'level'}";
$cmd .= "u" if ($_[0]->{'update'});
$cmd .= "v" if ($_[0]->{'verify'});
$cmd .= "o" if ($_[0]->{'offline'});
if ($_[0]->{'huser'}) {
	$cmd .= "f '$_[0]->{'huser'}\@$_[0]->{'host'}:".
		&date_subs($_[0]->{'hfile'})."'";
	}
elsif ($_[0]->{'host'}) {
	$cmd .= "f '$_[0]->{'host'}:".&date_subs($_[0]->{'hfile'})."'";
	}
else {
	$cmd .= "f '".&date_subs($_[0]->{'file'})."'";
	}
$cmd .= " $_[0]->{'extra'}" if ($_[0]->{'extra'});
$cmd .= " ".join(" ", map { "'$_'" } split(/\s+/, $_[0]->{'dir'}));

&system_logged("sync");
sleep(1);
&additional_log('exec', undef, $cmd);
open(CMD, "$cmd 2>&1 </dev/null |");
while(<CMD>) {
	if ($_[2]) {
		print $fh &html_escape($_);
		}
	else {
		print $fh $_;
		}
	}
close(CMD);
return $? ? 0 : 1;
}

# dump_dest(&dump)
sub dump_dest
{
if ($_[0]->{'file'}) {
	return "<tt>".&html_escape($_[0]->{'file'})."</tt>";
	}
elsif ($_[0]->{'huser'}) {
	return "<tt>".&html_escape("$_[0]->{'huser'}\@$_[0]->{'host'}:$_[0]->{'hfile'}")."</tt>";
	}
else {
	return "<tt>".&html_escape("$_[0]->{'host'}:$_[0]->{'hfile'}")."</tt>";
	}
}

# missing_restore_command(filesystem)
sub missing_restore_command
{
return &has_command("ufsrestore") ? undef : "ufsrestore";
}

# restore_form(filesystem)
sub restore_form
{
# common options
print "<tr> <td valign=top><b>",&hlink($text{'restore_src'}, "rsrc"),
      "</b></td>\n";
printf "<td colspan=3><input type=radio name=mode value=0 %s> %s\n",
        $_[1]->{'host'} ? "" : "checked", $text{'dump_file'};
printf "<input name=file size=50 value='%s'> %s<br>\n",
        $_[1]->{'host'} ? "" : $_[0]->{'file'}, &file_chooser_button("file");
printf "<input type=radio name=mode value=1 %s>\n",
        $_[1]->{'host'} ? "checked" : "";
print &text('dump_host',
            "<input name=host size=15 value='$_[1]->{'host'}'>",
            "<input name=huser size=8 value='$_[1]->{'huser'}'>",
            "<input name=hfile size=20 value='$_[1]->{'hfile'}'>"),
      "</td> </tr>\n";

print "<tr> <td><b>",&hlink($text{'restore_files'},"rfiles"),
      "</b></td>\n";
print "<td colspan=3><input type=radio name=files_def value=1 checked> ",
      "$text{'restore_all'}\n";
print "<input type=radio name=files_def value=0> $text{'restore_sel'}\n";
print "<input name=files size=40></td> </tr>\n";

print "<tr> <td><b>",&hlink($text{'restore_dir'},"rdir"),"</td>\n";
print "<td><input name=dir size=40> ",&file_chooser_button("dir", 1),
      "</td> </tr>\n";

print "<tr> <td><b>",&hlink($text{'restore_test'},"rtest"),"</td>\n";
print "<td><input type=radio name=test value=1> $text{'yes'}\n";
print "<input type=radio name=test value=0 checked> $text{'no'}</td> </tr>\n";
}

# parse_restore(filesystem)
# Parses inputs from restore_form() and returns a command to be passed to
# restore_backup()
sub parse_restore
{
local $cmd;
$cmd = "ufsrestore";
$cmd .= ($in{'test'} ? " t" : " x");
if ($in{'mode'} == 0) {
	$in{'file'} || &error($text{'restore_efile'});
	$cmd .= "f '$in{'file'}'";
	}
else {
	gethostbyname($in{'host'}) || &check_ipaddress($in{'host'}) ||
		&error($text{'restore_ehost'});
	$in{'huser'} =~ /^\S*$/ || &error($text{'restore_ehuser'});
	$in{'hfile'} || &error($text{'restore_ehfile'});
	if ($in{'huser'}) {
		$cmd .= "f '$in{'huser'}\@$in{'host'}:$in{'hfile'}'";
		}
	else {
		$cmd .= "f '$in{'host'}:$in{'hfile'}'";
		}
	}

$cmd .= " $in{'extra'}" if ($in{'extra'});
if (!$in{'files_def'}) {
	$in{'files'} || &error($text{'restore_efiles'});
	$cmd .= " $in{'files'}";
	}
-d $in{'dir'} || &error($text{'restore_edir'});

return $cmd;
}

# restore_backup(filesystem, command)
# Restores a backup based on inputs from restore_form(), and displays the results
sub restore_backup
{
&additional_log('exec', undef, $_[1]);

&foreign_require("proc", "proc-lib.pl");
local ($fh, $fpid) = &foreign_call("proc", "pty_process_exec", "cd '$in{'dir'}' ; $_[1]");
local $donevolume;
while(1) {
	local $rv = &wait_for($fh, "(next volume #)", "(set owner.mode for.*\\[yn\\])", "(Directories already exist, set modes anyway. \\[yn\\])", "((.*)\\[yn\\])", "(.*\\n)");
	last if ($rv < 0);
	print &html_escape($matches[1]);
	if ($rv == 0) {
		if ($donevolume++) {
			return $text{'restore_evolume'};
			}
		else {
			syswrite($fh, "1\n", 2);
			}
		}
	elsif ($rv == 1 || $rv == 2) {
		syswrite($fh, "n\n", 2);
		}
	elsif ($rv == 3) {
		return &text('restore_equestion',
			     "<tt>$matches[2]</tt>");
		}
	}
close($fh);
waitpid($fpid, 0);
return $? || undef;
}

1;

