#!/usr/local/bin/perl
# exec_files.cgi
# Execute some SQL commands from a file and display the output

require './postgresql-lib.pl';
&ReadParseMime();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
&error_setup($text{'exec_err'});

if ($in{'mode'}) {
	# From uploaded file
	$in{'upload'} || &error($text{'exec_eupload'});
	$file = &tempname();
	open(TEMP, ">$file");
	print TEMP $in{'upload'};
	close(TEMP);
	&ui_print_header(undef, $text{'exec_title'}, "");
	print "$text{'exec_uploadout'}<p>\n";
	}
else {
	# From local file
	-r $in{'file'} || &error($text{'exec_efile'});
	$file = $in{'file'};
	&ui_print_header(undef, $text{'exec_title'}, "");
	print &text('exec_fileout', "<tt>$in{'file'}</tt>"),"<p>\n";
	}

# Call the psql program on the file
local $cmd = "$config{'psql'} -u -f $file".
	     ($config{'host'} ? " -h $config{'host'}" : "").
	     ($config{'port'} ? " -h $config{'port'}" : "").
	     " $in{'db'}";
print "<pre>";
&additional_log('exec', undef, $cmd);
$ltemp = &tempname();
open(TEMP, ">$ltemp");
print TEMP "$postgres_login\n$postgres_pass\n";
close(TEMP);
if ($postgres_sameunix && defined(getpwnam($postgres_login))) {
	$cmd = "su $postgres_login -c ".quotemeta($cmd);
	}
open(SQL, "$cmd 2>&1 <$ltemp |");
while(<SQL>) {
	print &html_escape($_);
	$got++ if (/\S/);
	}
close(SQL);
unlink($ltemp);
print "<i>$text{'exec_noout'}</i>\n" if (!$got);
print "</pre>\n";
&webmin_log("execfile", undef, $in{'db'}, { 'mode' => $in{'mode'},
					    'file' => $in{'file'} });
unlink($file) if ($in{'mode'});

&ui_print_footer("edit_dbase.cgi?db=$in{'db'}", $text{'dbase_return'},
	"", $text{'index_return'});

