#!/usr/local/bin/perl
# view_log.cgi
# Display the report for some log file

require './webalizer-lib.pl';
&ReadParse();

$ENV{'PATH_INFO'} =~ /^\/([^\/]+)(\/.*)$/ || &error($text{'view_epath'});
$escaped = $1;
$file = $2;
$log = &un_urlize($escaped);
$file =~ /\.\./ || $file =~ /\<|\>|\||\0/ && &error($text{'view_efile'});
&can_edit_log($log) || &error($text{'view_ecannot'});

$lconf = &get_log_config($log) || &error($text{'view_elog'}." : $log");
$full = "$lconf->{'dir'}$file";
open(FILE, $full) || &error($text{'view_eopen'}." : $full");

# Display file contents
if ($full =~ /\.(html|htm)$/i) {
	while(read(FILE, $buf, 1024)) {
		$data .= $buf;
		}
	close(FILE);
	$data =~ /<TITLE>(.*)<\/TITLE>/i;
	$title = $1;
	$data =~ s/^[\000-\377]*<BODY.*>//i;
	$data =~ s/<\/BODY>[\000-\377]*$//i;

	&ui_print_header(undef, $title || $text{'view_title'}, "");
	print $data;
	&ui_print_footer("/$module_name/edit_log.cgi?file=$escaped",$text{'edit_return'},
		"", $text{'index'});
	}
else {
	print "Content-type: ",$full =~ /\.png$/i ? "image/png" :
			       $full =~ /\.gif$/i ? "image/gif" :
			       $full =~ /\.(jpg|jpeg)$/i ? "image/jpeg" :
			       $full =~ /\.(html|htm)$/i ? "text/html" :
							   "text/plain","\n";
	print "\n";
	while(read(FILE, $buf, 1024)) {
		print $buf;
		}
	close(FILE);
	}

