#!/usr/local/bin/perl
# Remove firewall rules and syslog entry

require './bandwidth-lib.pl';
&ReadParse();
$access{'setup'} || &error($text{'turnoff_ecannot'});

# Remove firewall rules
$err = &delete_rules();
&error($err) if ($err);

# Remove syslog entry
$conf = &syslog::get_config();
$sysconf = &find_sysconf($conf);
if ($sysconf) {
	&lock_file($syslog::config{'syslog_conf'});
	&syslog::delete_log($sysconf);
	&unlock_file($syslog::config{'syslog_conf'});
	$err = &syslog::restart_syslog();
	&error($err) if ($err);
	}

# Remove rotation cron job
$job = &find_cron_job();
if ($job) {
	&lock_file(&cron::cron_file($job));
	&cron::delete_cron_job($job);
	&unlock_file(&cron::cron_file($job));
	}

&webmin_log("turnoff");
&redirect("");

