#!/usr/local/bin/perl
# save_group.cgi
# Create, update or delete a postgres group

require './postgresql-lib.pl';
&ReadParse();
$access{'users'} || &error($text{'group_ecannot'});
&error_setup($text{'group_err'});

if ($in{'delete'}) {
	# just delete the group
	&execute_sql_logged($config{'basedb'}, "delete from pg_group where grosysid = $in{'gid'}");
	&webmin_log("delete", "group", $in{'name'});
	}
else {
	# parse inputs
	$in{'name'} =~ /^\S+$/ || &error($text{'group_ename'});
	$s = &execute_sql($config{'basedb'}, "select * from pg_group where groname = '$in{'name'}'");
	$in{'gid'} =~ /^\d+$/ || &error($text{'group_egid'});
	if ($in{'new'}) {
		$s->{'data'}->[0]->[0] && &error($text{'group_etaken'});
		}
	else {
		$s->{'data'}->[0]->[0] && $s->{'data'}->[0]->[1] != $in{'gid'} && &error($text{'group_etaken'});
		}

	$mems = &join_array(split(/\0/, $in{'mems'}));
	if ($in{'new'}) {
		&execute_sql_logged($config{'basedb'}, "insert into pg_group values ('$in{'name'}', '$in{'gid'}', '$mems')");
		&webmin_log("create", "group", $in{'name'});
		}
	else {
		&execute_sql_logged($config{'basedb'}, "update pg_group set groname = '$in{'name'}', grolist = '$mems' where grosysid = $in{'gid'}");
		&webmin_log("modify", "group", $in{'name'});
		}
	}
&redirect("list_groups.cgi");

