#!/usr/local/bin/perl
# index.cgi
# Display the current list of procmail recipes

require './procmail-lib.pl';
if ($minfo{'usermin'}) {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1);
	}
else {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1);
	}

@conf = &get_procmailrc();
print &text('index_desc', "<tt>$procmailrc</tt>"),"<p>\n";

if (@conf) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td width=50%><b>$text{'index_action'}</b></td> ",
	      "<td width=50%><b>$text{'index_conds'}</b></td> ",
	      "<td width=32><b>$text{'index_move'}</b></td> ",
	      "<td width=32><b>$text{'index_ba'}</b></td> </tr>\n";
	foreach $c (@conf) {
		print "<tr $cb>\n";
		if ($c->{'name'}) {
			# Environment variable assignment
			local $v = length($c->{'value'}) > 80 ?
					substr($c->{'value'}, 0, 80)." ..." :
					$c->{'value'};
			print "<td width=100% colspan=2>";
			print "<a href='edit_env.cgi?idx=$c->{'index'}'>",
			      &text('index_env',
			    	"<tt>".&html_escape($c->{'name'})."</tt>",
				"<tt>".&html_escape($v)."</tt>"),"</a>\n";
			}
		elsif ($c->{'include'}) {
			# Included file
			print "<td width=100% colspan=2>";
			print "<a href='edit_inc.cgi?idx=$c->{'index'}'>",
				&text('index_include', 
				"<tt>".&html_escape($c->{'include'})."</tt>"),
				"</a>\n";
			}
		else {
			# Procmail recipe
			print "<td valign=top width=50%>";
			print "<a href='edit_recipe.cgi?idx=$c->{'index'}'>";
			local ($t, $a) = &parse_action($c);
			print &text('index_act'.$t,
				    "<tt>".&html_escape($a)."</tt>");
			print "</a></td>\n";

			print "<td width=50%>";
			local @c = @{$c->{'conds'}};
			if (!@c) {
				print $text{'index_noconds'};
				}
			else {
				foreach $n (@c) {
					local $he ="<tt>".&html_escape($n->[1]).
						   "</tt>";
					if ($n->[0] eq '') {
						print &text('index_re', $he);
						}
					elsif ($n->[0] eq '!') {
						print &text('index_nre', $he);
						}
					elsif ($n->[0] eq '$') {
						print &text('index_shell', $he);
						}
					elsif ($n->[0] eq '?') {
						print &text('index_exit', $he);
						}
					elsif ($n->[0] eq '<') {
						print &text('index_lt',
							    $n->[1]);
						}
					elsif ($n->[0] eq '>') {
						print &text('index_gt',
							    $n->[1]);
						}
					print "<br>\n";
					}
				}
			}
		print "</td> <td width=32>\n";

		if ($c eq $conf[@conf-1] ||
		    $c->{'file'} ne $conf[$c->{'index'}+1]->{'file'}) {
			print "<img src=images/gap.gif>";
			}
		else {
			print "<a href='down.cgi?idx=$c->{'index'}'>",
			      "<img src=images/down.gif border=0></a>";
			}
		if ($c eq $conf[0] ||
		    $c->{'file'} ne $conf[$c->{'index'}-1]->{'file'}) {
			print "<img src=images/gap.gif>";
			}
		else {
			print "<a href='up.cgi?idx=$c->{'index'}'>",
			      "<img src=images/up.gif border=0></a>";
			}
		print "</td>\n";
		print "<td><a href='edit_recipe.cgi?new=1&before=$c->{'index'}'><img src=images/before.gif border=0></a>";
		print "<a href='edit_recipe.cgi?new=1&after=$c->{'index'}'><img src=images/after.gif border=0></a></td>";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<a href='edit_recipe.cgi?new=1'>$text{'index_add'}</a>&nbsp;&nbsp;\n";
print "<a href='edit_recipe.cgi?new=1&block=1'>$text{'index_badd'}</a>&nbsp;&nbsp;\n";
print "<a href='edit_env.cgi?new=1'>$text{'index_eadd'}</a>&nbsp;&nbsp;\n";
print "<a href='edit_inc.cgi?new=1'>$text{'index_iadd'}</a>&nbsp;&nbsp;\n"
	if (!$includes);
print "<a href='manual_form.cgi'>$text{'index_manual'}</a>&nbsp;&nbsp;\n";
print "<p>\n";

&ui_print_footer("/", $text{'index'});

