#!/usr/local/bin/perl
# user_filesys.cgi
# List all filesystems for which some user has quotas

require './quota-lib.pl';
&ReadParse();
$u = $in{'user'};
&can_edit_user($u) ||
	&error(&text('ufilesys_ecannot', $u));
&ui_print_header(undef, $text{'ufilesys_title'}, "", "user_filesys");

foreach $f (&list_filesystems()) {
	if ($f->[4]%2 && $f->[5] && &can_edit_filesys($f->[0])) {
		push(@fslist, $f->[0]);
		$fslist{$f->[0]}++;
		}
	}

# Make sure all block sizes are the same
$n = &user_filesystems($u);
for($i=0; $i<$n; $i++) {
	$bsize = &block_size($filesys{$i,'filesys'});
	if ($last_bsize && $last_bsize != $bsize) {
		$variable_bsize++;
		}
	}

if ($n) {
	print &ui_subheading(&text('ufilesys_all', &html_escape($u)));
	print "<table border width=100%>\n";
	print "<tr $tb> <td><br></td>\n";
	$cols = 3 + ($config{'show_grace'} ? 1 : 0);
	if (!$variable_bsize) {
		print "<td colspan=$cols align=center><b>$text{'ufilesys_space'}</b></td>\n";
		}
	else {
		print "<td colspan=$cols align=center><b>$text{'ufilesys_blocks'}</b></td>\n";
		}
	print "<td colspan=$cols align=center><b>$text{'ufilesys_files'}</b></td> </tr>\n";
	print "<tr $tb>\n";
	print "<td><b>$text{'ufilesys_fs'}</b></td>\n";
	print "<td><b>$text{'ufilesys_used'}</b></td> <td><b>$text{'ufilesys_soft'}</b></td>\n";
	print "<td><b>$text{'ufilesys_hard'}</b></td>\n";
	print "<td><b>$text{'ufilesys_grace'}</b></td>\n"
		if ($config{'show_grace'});
	print "<td><b>$text{'ufilesys_used'}</b></td> <td><b>$text{'ufilesys_soft'}</b></td>\n";
	print "<td><b>$text{'ufilesys_hard'}</b></td>\n";
	print "<td><b>$text{'ufilesys_grace'}</b></td>\n"
		if ($config{'show_grace'});
	print "</tr>\n";
	for($i=0; $i<$n; $i++) {
		$f = $filesys{$i,'filesys'};
		$bsize = &block_size($f);
		print "<tr $cb>\n";
		if ($fslist{$f} && !$access{'ro'}) {
			print "<td><a href=\"edit_user_quota.cgi?filesys=$f&user=$u&source=1\">$f</a></td>\n";
			}
		else { print "<td>$f</td>\n"; }
		if ($bsize) {
			print "<td>",&nice_size($filesys{$i,'ublocks'}*$bsize),"</td>\n";
			}
		else {
			print "<td>$filesys{$i,'ublocks'}</td>\n";
			}
		&print_limit($filesys{$i,'sblocks'});
		&print_limit($filesys{$i,'hblocks'});
		&print_grace($filesys{$i,'gblocks'}) if ($config{'show_grace'});
		print "<td>$filesys{$i,'ufiles'}</td>\n";
		&print_limit($filesys{$i,'sfiles'}, 1);
		&print_limit($filesys{$i,'hfiles'}, 1);
		&print_grace($filesys{$i,'gfiles'}) if ($config{'show_grace'});
		print "</tr>\n";
		}
	print "</table><br>\n";
	}
else {
	print "<b>",&text('ufilesys_nouquota', $u),"</b><p>\n";
	}

if (!$access{'ro'}) {
	print "<table width=100%><tr>\n";
	print "<form action=edit_user_quota.cgi>\n";
	print "<input type=hidden name=user value=\"$u\">\n";
	print "<input type=hidden name=source value=1>\n";
	print "<td align=left><input type=submit value=\"$text{'ufilesys_edit'}\">\n";
	print "<select name=filesys>\n";
	foreach $f (@fslist) { print "<option>$f\n"; }
	print "</select></td></form>\n";

	if ($access{'filesys'} eq "*") {
		print "<form action=copy_user_form.cgi>\n";
		print "<input type=hidden name=user value=\"$u\">\n";
		print "<td align=right><input type=submit value=\"$text{'ufilesys_copy'}\">\n";
		print "</td></form>\n";
		}
	print "</tr></table>\n";
	}

&ui_print_footer("", $text{'ufilesys_return'});


