# csw-lib.pl
# Functions for installing packages from Blastwave

$pkg_get = -x "/opt/csw/bin/pkg-get" ? "/opt/csw/bin/pkg-get"
				     : &has_command("pkg-get");

# update_system_input()
# Returns HTML for entering a package to install
sub update_system_input
{
return "$text{'csw_input'} <input name=update size=20> <input type=button onClick='window.ifield = form.update; chooser = window.open(\"../$module_name/csw_find.cgi\", \"chooser\", \"toolbar=no,menubar=no,scrollbars=yes,width=400,height=500\")' value=\"$text{'csw_find'}\">";
}

# update_system_install([file])
# Install some package with pkg-get
sub update_system_install
{
local $update = $_[0] || $in{'update'};
local (@rv, @newpacks);
print "<b>",&text('csw_install', "<tt>$pkg_get -i $update</tt>"),"</b><p>\n";
$| = 1;
print "<pre>";
local ($ph, $ppid) = &foreign_call("proc", "pty_process_exec_logged",
				   "$pkg_get -i ".quotemeta($update));
while(1) {
	local $wf = &wait_for($ph, '(.*) \[\S+\]',
			     'Installation of <(.*)> failed',
			     'Installation of <(.*)> was successful',
			     'No changes were made to the system',
			     '.*\n', '.*\r');
	if ($wait_for_input !~ /^\s*\d+\%\s+\[/) {
		# Print everything except download line
		print &html_escape($wait_for_input);
		}
	if ($wf == 0) {
		# some question which should not have appeared before
		if ($seen{$matches[1]}++) {
			$failed++;
			last;
			}
		&sysprint($ph, "y\n");
		}
	elsif ($wf == 1) {
		# This package contains scripts
		$failed++;
		last;
		}
	elsif ($wf == 1 || $wf == 3) {
		# failed for some reason.. give up
		$failed++;
		last;
		}
	elsif ($wf == 2) {
		# done ok!
		push(@rv, $matches[1]);
		}
	elsif ($wf == -1) {
		# No more output
		last;
		}
	}
print "</pre>";
close($ph);
if ($? || $failed) {
	print "<b>$text{'csw_failed'}</b><p>\n";
	return ( );
	}
else {
	print "<b>$text{'csw_ok'}</b><p>\n";
	return @rv;
	}
}


