#!/usr/local/bin/perl
# domain_form.cgi
# Display a form for setting up a new virtual domain

require './virtual-server-lib.pl';
$access{'create'} || &error($text{'form_ecannot'});
&header($text{'form_title'}, "");
print "<hr>\n";

print <<EOF;
<form action=domain_setup.cgi method=post>
<table border width=100%>
<tr $tb> <td><b>$text{'form_header'}</b></td> </tr>
<tr $cb> <td><table width=100%>
EOF

print "<tr> <td><b>", &hlink($text{'form_domain'}, "domainname"), "</b></td>";
print "<td colspan=3><input name=dom size=40></td>\n";

print "<tr> <td><b>", &hlink($text{'form_owner'}, "ownersname"), "</b></td>";
print "<td colspan=3><input name=owner size=50></td>\n";

print "<tr> <td><b>", &hlink($text{'form_email'}, "ownersemail"), "</b></td>";
print "<td colspan=3><input type=radio name=email_def value=1 checked> ",
      $text{'form_email_def'};
print "<input type=radio name=email_def value=0> $text{'form_email_set'}\n";
print "<input name=email size=30></td> </tr>\n";

print "<tr> <td><b>", &hlink($text{'form_user'}, "unixusername"), "</b></td>";
print "<td nowrap colspan=3><input type=radio name=user_def value=1 checked> ",
      "$text{'form_auto'}";
print "<input type=radio name=user_def value=0> $text{'form_nwuser'} ";
print "<input name=user size=15></td> </tr>\n";

print "<tr> <td><b>", &hlink($text{'form_pass'}, "password"), "</b></td>";
print "<td colspan=3><input name=pass type=password size=15></td> </tr>\n";

print "<tr> <td><b>",&hlink($text{'form_mgroup'}, "mailgroupname"),"</b></td>";
print "<td colspan=3><input type=radio name=mgroup_def value=1 checked> ",
      "$text{'form_auto'}";
print "<input type=radio name=mgroup_def value=0> $text{'form_nwgroup'} ",
      "<input name=mgroup size=13></td> </tr>\n";

print "<tr> <td><b>",&hlink($text{'form_group'}, "unixgroupname"),"</b></td>";
print "<td colspan=3><input type=radio name=group_def value=1 checked> ",
      "$text{'form_crgroup'}";
print "<input type=radio name=group_def value=0> $text{'form_exgroup'}";
print &unix_group_input("group"),"</td> </tr>\n";

if ($config{'home_quotas'}) {
	print "<tr> <td><b>", &hlink($text{'form_quota'}, "websitequota"), "</b></td>\n";
	@defquota = split (/ /,$config{'defquota'});
	if ( !@defquota or $#defquota eq 0 ) {
	    print "<td>",&quota_input("quota", $config{'defquota'},
				      $config{'home_quotas'}),"</td>\n";
	} else {
	    print "<td><select name=quota>\n";
	    foreach $i (@defquota) {
		chomp $i;
		print "<option value=\"$i\">$i</option>\n";
	    }
	    print "<option value=\"-1\">$text{'other'}</option></select>\n";
	    print &quota_input("otherquota", "",
			       $config{'home_quotas'}),"</td>\n";
	}
	print "</tr>\n";

	print "<tr> <td><b>", &hlink($text{'form_uquota'}, "unixuserquota"), "</b></td>\n";
	@defuquota = split (/ /,$config{'defuquota'});
	if ( !@defuquota or $#defuquota eq 0 ) {
	    print "<td>",&quota_input("uquota", $config{'defuquota'},
				      $config{'home_quotas'}),"</td>\n";
	} else {
	    print "<td><select name=uquota>\n";
	    foreach $i (@defuquota) {
		chomp $i;
		print "<option value=\"$i\">$i</option>\n";
	    }
	    print "<option value=\"-1\">$text{'other'}</option></select>\n";
	    print &quota_input("otheruquota", "",
			       $config{'home_quotas'}),"</td>\n";
	}
	print "</tr>\n";
}

print "<tr> <td><b>",&hlink($text{'form_mailboxlimit'},
			    "mailboxlimit"),"</b></td> <td colspan=2>\n";
printf "<input type=radio name=mailboxlimit_def value=1 %s> %s\n",
	$config{'defmailboxlimit'} ? "" : "checked", $text{'form_unlimit'};
printf "<input type=radio name=mailboxlimit_def value=0 %s> %s\n",
	$config{'defmailboxlimit'} ? "checked" : "", $text{'form_atmost'};
print "<input name=mailboxlimit value='$config{'defmailboxlimit'}' size=4></td></tr>\n";

print "<tr> <td><b>",&hlink($text{'form_mailbox'},"usermailbox"),"</b></td>\n";
print "<td><input type=radio name=mailbox value=1> $text{'yes'}\n";
print "<input type=radio name=mailbox value=0 checked> $text{'no'}</td></tr>\n";

print "<tr> <td colspan=4><hr></td> </tr>\n";

$i = 0;
foreach $f (@opt_features) {
	print "<tr>\n" if ($i%2 == 0);
	print "<td><b>",&hlink($text{'form_'.$f}, $f),"</b></td>";
	if ($config{$f} || !defined($config{$f})) {
		print "<td nowrap>\n";
		print "<input type=radio name=$f value=1 checked> $text{'yes'}";
		print "<input type=radio name=$f value=0> $text{'no'}</td>\n";
		}
	else {
		print "<td><i>$text{'form_unavail'}</i></td>\n";
		}
	print "</tr>\n" if ($i++%2 == 1);
	}

if ($config{'proxy_pass'}) {
	print "<tr> <td><b>",&hlink($text{'form_proxy'},
				    "proxypass"),"</b></td>\n";
	print "<td colspan=3>";
	print "<input type=radio name=proxy_def value=1 checked> ",
	      "$text{'form_plocal'}\n";
	print "<input type=radio name=proxy_def value=0> ",
	      "$text{'form_purl'}\n";
	print "<input name=proxy size=40></td> </tr>\n";
	}

$defip = &get_default_ip();
print "<tr> <td><b>",&hlink($text{'form_iface'},"iface"),"</b></td>\n";
if ($config{'all_namevirtual'}) {
	print "<td><input name=ip size=20 value=\"$defip\"></td> </tr>\n";
	}
else {
	print "<td colspan=3>\n";
	print "<input type=radio name=virt value=0 checked> ",
	      &text('form_shared', $defip),"\n";
	print "<input type=radio name=virt value=1> $text{'form_vip'}\n";
	print "<input name=ip size=20></td> </tr>\n";
	}

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'form_ok'}'></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

