#!/usr/local/bin/perl
# save_newweb.cgi
# Update the Apache configuration template

require './virtual-server-lib.pl';
$master_admin || &error($text{'newweb_ecannot'});
&ReadParseMime();
&error_setup($text{'newweb_err'});

$in{'apache_config'} =~ s/\r//g;
$in{'apache_config'} =~ s/\t/ /g;
$config{'apache_config'} = join("\t", split(/\n/, $in{'apache_config'}));
$err = &check_apache_directives();
&error($err) if ($err);
$config{'suexec'} = $in{'suexec'};
if ($in{'html_dir_def'}) {
	delete($config{'html_dir'});
	}
else {
	$in{'html_dir'} =~ /^\S+$/ && $in{'html_dir'} !~ /^\// &&
		$in{'html_dir'} !~ /\.\./ || &error($text{'newweb_ehtml'});
	$config{'html_dir'} = $in{'html_dir'};
	}
if ($in{'stats_dir_def'}) {
	delete($config{'stats_dir'});
	}
else {
	$in{'stats_dir'} =~ /^\S+$/ && $in{'stats_dir'} !~ /^\// &&
		$in{'stats_dir'} !~ /\.\./ || &error($text{'newweb_estats'});
	$config{'stats_dir'} = $in{'stats_dir'};
	}

$old_web_port = $web_port;
$old_web_sslport = $web_sslport;

$in{'web_port'} =~ /^\d+$/ && $in{'web_port'} > 0 &&
	$in{'web_port'} < 65536 || &error($text{'newweb_eport'});
$config{'web_port'} = $in{'web_port'};
$in{'web_sslport'} =~ /^\d+$/ && $in{'web_sslport'} > 0 &&
	$in{'web_sslport'} < 65536 || &error($text{'newweb_esslport'});
$in{'web_port'} != $in{'web_sslport'} || &error($text{'newweb_esslport2'});
$config{'web_sslport'} = $in{'web_sslport'};

&lock_file($module_config_file);
$config{'last_check'} = time()+1;	# no need for check.cgi to be run
&write_file($module_config_file, \%config);
&unlock_file($module_config_file);

# If the web or SSL ports were changed, all existing virtual hosts should be
# updated with the *old* setting to that we know what port they were created on
if ($old_web_port != $in{'web_port'} ||
    $old_web_sslport != $in{'web_sslport'}) {
	foreach $d (&list_domains()) {
		&save_domain($d);
		}
	}

&webmin_log("newweb");
&redirect("");

