#!/usr/local/bin/perl
# delete_domain.cgi
# Delete a domain, after asking first

require './virtual-server-lib.pl';
&require_bind() if ($config{'dns'});
&require_useradmin();
&require_mail() if ($config{'mail'});
&ReadParse();
$d = &get_domain($in{'dom'});
$d && $d->{'uid'} && $d->{'gid'} || &error("Domain $in{'dom'} does not exist!");
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
&master_admin() || $d->{'parent'} || &error($text{'edit_ecannot'});

if ($in{'confirm'}) {
	$| = 1;
	$theme_no_table++;
	}
&header($text{'delete_title'}, "");
print "<hr>\n";

@users = &list_domain_users($d, 1);
@aliases = &list_domain_aliases($d);
@subs = &get_domain_by("parent", $d->{'id'});
if (!$in{'confirm'}) {
	# Ask the user if he is sure
	print &check_clicks_function();
	$sz = &disk_usage_kb($d->{'home'});
	print "<p>",&text('delete_rusure2', "<tt>$d->{'dom'}</tt>",
		  	  &nice_size($sz*1024)),"<p>\n";

	$pfx = $d->{'parent'} ? "sublosing_" : "losing_";
	print "<ul>\n";
	foreach $f (@features) {
		if ($d->{$f} && ($config{$f} || $f eq 'unix')) {
			print "<li>",$text{'feature_'.$f}," - ",
				     $text{$pfx.$f},"<br>\n";
			}
		}
	if (@users || @aliases) {
		print "<li>",&text('delete_mailboxes', scalar(@users), scalar(@aliases)),"<br>\n";
		}
	print "</ul>\n";

	if (@subs) {
		print "<p><font size=+1>",&text('delete_subs',
			join(", ", map { "<tt>$_->{'dom'}</tt>" } @subs)),
			"</font><p>\n";
		}

	print "<center><form action=delete_domain.cgi>\n";
	print "<input type=hidden name=dom value='$in{'dom'}'>\n";
	print "<input type=submit name=confirm ",
	      "value='$text{'delete_ok'}' onClick='check_clicks(form)'>\n";
	if ($access{'edit'} == 1) {
		print "<p><input type=checkbox name=only value=1> ",
		      "$text{'delete_only'}<br>\n";
		}
	print "</form></center>\n";

	print "<hr>\n";
	&footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		"", $text{'index_return'});
	}
else {
	# Go ahead and delete this domain and all sub-domains ..

	foreach $dd (@subs, $d) {
		# Run the before command
		&set_domain_envs($dd, "DELETE_DOMAIN");
		$merr = &making_changes();
		&error(&text('delete_emaking', "<tt>$merr</tt>"))
			if (defined($merr));

		# Delete domain file
		print &text('delete_domain', "<tt>$dd->{'dom'}</tt>"),"<br>\n";
		&delete_domain($dd);
		print $text{'setup_done'},"<p>\n";

		$in{'only'} = 0 if ($access{'edit'} != 1);
		if (!$in{'only'}) {
			if (@users) {
				# Delete mail users and their mail files
				print $text{'delete_users'},"<br>\n";
				foreach $u (@users) {
					&delete_user($u);
					&delete_mail_file($u);
					&system_logged("rm -rf '$u->{'home'}'")
						if (-d $u->{'home'} &&
						    $u->{'home'} ne "/");
					}
				print $text{'setup_done'},"<p>\n";
				}

			# Delete all virtusers
			if (@users || @aliases) {
				print $text{'delete_aliases'},"<br>\n";
				foreach $v (&list_virtusers()) {
					if ($v->{'from'} =~ /\@(\S+)$/ &&
					    $1 eq $dd->{'dom'}) {
						&delete_virtuser($v);
						}
					}
				print $text{'setup_done'},"<p>\n";
				}

			# Take down IP
			if ($dd->{'iface'}) {
				&delete_virt($dd);
				}
			}

		# Delete all features (or just 'webmin' if un-importing)
		my $f;
		foreach $f ($in{'only'} ? ( "webmin" ) : reverse(@features)) {
			if ($config{$f} && $dd->{$f} || $f eq 'unix') {
				local $dfunc = "delete_$f";
				&$dfunc($dd);
				}
			}

		# Update the parent domain Webmin user, so that his ACL
		# is refreshed
		if ($dd->{'parent'} && $dd->{'parent'} != $d->{'id'}) {
			$parentdom = &get_domain($d->{'parent'});
			&modify_webmin($parentdom, $parentdom);
			}
		}

	# Run the after command
	&run_post_actions();
	&made_changes();
	&webmin_log("delete", "domain", $d->{'dom'}, $d);

	print "<hr>\n";
	&footer("", $text{'index_return'});
	}

