#!/usr/local/bin/perl
# disable_domain.cgi
# Temporarily disable a domain, after asking first

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
$d->{'disabled'} && &error($text{'disable_ealready'});

if ($in{'confirm'}) {
	$| = 1;
	$theme_no_table++;
	}
&header($text{'disable_title'}, "");
print "<hr>\n";

# Work out what can be disabled
@disable = grep { $d->{$_} && $config{$_} || $_ eq 'unix' }
		split(/,/, $config{'disable'});
push(@disable, "ssl") if (&indexof("web", @disable) >= 0 && $d->{'ssl'});
@disable = grep { $_ ne "unix" } @disable if ($d->{'parent'});

if (!@disable) {
	# Nothing to do!
	print "<p>$text{'disable_nothing'}<p>\n";
	}
elsif (!$in{'confirm'}) {
	# Ask the user if he is sure
	@distext = map { $text{"disable_f".$_} } @disable;
	if (@distext == 1) {
		$distext = $distext[0];
		}
	elsif (@distext == 2) {
		$distext = &text('disable_and', $distext[0], $distext[1]);
		}
	else {
		$dislast = pop(@distext);
		$distext = &text('disable_and', join(", ", @distext), $dislast);
		}

	print &check_clicks_function();
	print "<p>",&text('disable_rusure2', "<tt>$d->{'dom'}</tt>",
			  $distext),"<p>\n";
	print $text{'disable_undo'},"<p>\n";
	print "<center><form action=disable_domain.cgi>\n";
	print "<input type=hidden name=dom value='$in{'dom'}'>\n";
	print "<input type=submit name=confirm ",
	      "value='$text{'disable_ok'}' onClick='check_clicks(form)'>\n";
	print "</form></center>\n";
	}
else {
	# Go ahead and do it ..
	%disable = map { $_, 1 } @disable;

	# Run the before command
	&set_domain_envs($d, "DISABLE_DOMAIN");
	$merr = &making_changes();
	&error(&text('disable_emaking', "<tt>$merr</tt>")) if (defined($merr));

	# Disable all configured features
	my $f;
	foreach $f (@features) {
		if ($d->{$f} && $disable{$f}) {
			local $dfunc = "disable_$f";
			&$dfunc($d);
			push(@disabled, $f);
			}
		}

	# Save new domain details
	print $text{'save_domain'},"<br>\n";
	$d->{'disabled'} = join(",", @disabled);
	&save_domain($d);
	print $text{'setup_done'},"<p>\n";

	# Run the after command
	&run_post_actions();
	&set_domain_envs($d, "DISABLE_DOMAIN");
	&made_changes();
	&webmin_log("disable", "domain", $d->{'dom'}, $d);
	}

print "<hr>\n";
&footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});

