#!/usr/local/bin/perl
# edit_limits.cgi
# Display access control and usage limits for this domain's user

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} == 1 && &can_edit_domain($d) || &error($text{'edit_ecannot'});
%uaccess = &get_module_acl($d->{'user'});

&header($text{'limits_title'}, "");
&domain_title($d);
print "<hr>\n";

print "$text{'limits_desc'}<p>\n";

print "<form action=save_limits.cgi method=post>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'limits_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'edit_domain'}</b></td>\n";
print "<td><tt>$d->{'dom'}</tt></td>\n";

print "<td><b>$text{'edit_user'}</b></td>\n";
print "<td><tt>$d->{'user'}</tt></td> </tr>\n";

# Maximum allowed mailboxes
print "<tr> <td><b>$text{'form_mailboxlimit'}</b></td> <td colspan=2>\n";
printf "<input type=radio name=mailboxlimit_def value=1 %s> %s\n",
	$d->{'mailboxlimit'} ? "" : "checked", $text{'form_unlimit'};
printf "<input type=radio name=mailboxlimit_def value=0 %s> %s\n",
	$d->{'mailboxlimit'} ? "checked" : "", $text{'form_atmost'};
print "<input name=mailboxlimit value='$d->{'mailboxlimit'}' size=4></td></tr>\n";

# Can create and edit domains?
$dlm = $d->{'domslimit'} eq "" ? 1 :
       $d->{'domslimit'} eq "*" ? 2 : 0;
print "<tr> <td><b>$text{'form_domslimit'}</b></td> <td colspan=2>\n";
printf "<input type=radio name=domslimit_def value=1 %s> %s\n",
	$dlm == 1 ? "checked" : "",
	$text{'no'};
printf "<input type=radio name=domslimit_def value=2 %s> %s\n",
	$dlm == 2 ? "checked" : "",
	$text{'form_domsunlimit'};
printf "<input type=radio name=domslimit_def value=0 %s> %s\n",
	$dlm == 0 ? "checked" : "",
	$text{'form_domsyes'};
printf "<input name=domslimit value='%s' size=4></td></tr>\n",
	$dlm == 0 ? $d->{'domslimit'} : "";

# Allowed features
print "<tr> <td valign=top><b>$text{'limits_features'}</b></td>\n";
print "<td colspan=3><table>\n";
foreach $f (@opt_features) {
	next if ($f eq "webmin");	# makes no sense for subdomains
	print "<tr>\n" if ($i%2 == 0);
	printf "<td><input type=checkbox name=features value=%s %s> %s</td>\n",
		$f, $d->{"limit_$f"} ? "checked" : "",
		$text{'feature_'.$f};
	print "</tr>\n" if ($i++%2 == 1);
	}
print "</table></td> </tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";

print "<hr>\n";
&footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});

