#!/usr/local/bin/perl
# edit_newweb.cgi
# Display the current Apache configuration template

require './virtual-server-lib.pl';
&master_admin() || &error($text{'newweb_ecannot'});
&header($text{'newweb_title'}, "");
print "<hr>\n";

print "<form action=save_newweb.cgi method=post enctype=multipart/form-data>\n";
print "$text{'newweb_desc'}<br>\n";
&print_subs_table("DOM", "USER", "IP");
print "<textarea name=apache_config rows=10 cols=70>";
print join("\n", map { &html_escape($_) }
		     split(/\t/, $config{'apache_config'}));
print "</textarea><br>\n";

print "<table>\n";

# Input for adding suexec directives
print "<tr> <td><b>$text{'newweb_suexec'}</b></td>\n";
printf "<td nowrap><input type=radio name=suexec value=1 %s> %s\n",
	$config{'suexec'} ? "checked" : "", $text{'yes'};
printf "<input type=radio name=suexec value=0 %s> %s</td> </tr>\n",
	$config{'suexec'} ? "" : "checked", $text{'no'};

# Input for Apache user to add to domain's group
print "<tr> <td><b>$text{'newweb_user'}</b></td>\n";
printf "<td nowrap><input type=radio name=user_def value=1 %s> %s\n",
	$config{'web_user'} ? "" : "checked", $text{'no'};
printf "<input type=radio name=user_def value=0 %s> %s\n",
	$config{'web_user'} ? "checked" : "", $text{'newweb_useryes'};
print &unix_user_input("user", $config{'web_user'}),"</td> </tr>\n";

# HTML sub-directory input
print "<tr> <td valign=top><b>$text{'newweb_htmldir'}</b></td>\n";
printf "<td nowrap><input type=radio name=html_dir_def value=1 %s> %s (%s)\n",
	$config{'html_dir'} ? "" : "checked", $text{'default'},
	"<tt>public_html</tt>";
printf "<br><input type=radio name=html_dir_def value=0 %s> %s\n",
	$config{'html_dir'} ? "checked" : "", $text{'newweb_htmldir0'};
printf "<input name=html_dir size=20 value='%s'> %s</td> </tr>\n",
	$config{'html_dir'}, $text{'newweb_htmldir0suf'};
$hdir = $config{'html_dir'} || "public_html";

# Webalizer stats sub-directory input
$smode = $config{'stats_hdir'} ? 2 :
	 $config{'stats_dir'} ? 1 : 0;
print "<tr> <td valign=top><b>$text{'newweb_statsdir'}</b></td>\n";
printf "<td nowrap><input type=radio name=stats_mode value=0 %s> %s (%s)\n",
	$smode == 0 ? "checked" : "", $text{'default'},
	"<tt>$hdir/stats</tt>";
printf "<br><input type=radio name=stats_mode value=1 %s> %s\n",
	$smode == 1 ? "checked" : "",
	&text('newweb_statsdir0', "<tt>$hdir</tt>");
printf "<input name=stats_dir size=20 value='%s'>\n",
	$config{'stats_dir'};
printf "<br><input type=radio name=stats_mode value=2 %s> %s\n",
	$smode == 2 ? "checked" : "",
	&text('newweb_statsdir2', "<tt>$hdir</tt>");
printf "<input name=stats_hdir size=20 value='%s'>\n",
	$config{'stats_hdir'};
print "</td> </tr>\n";

# Port for normal webserver
print "<tr> <td><b>$text{'newweb_port'}</b></td>\n";
printf "<td><input name=web_port size=6 value='%s'></td> </tr>\n",
	$web_port;

# Port for SSL webserver
print "<tr> <td><b>$text{'newweb_sslport'}</b></td>\n";
printf "<td><input name=web_sslport size=6 value='%s'></td> </tr>\n",
	$web_sslport;

print "</table>\n";

print "<input type=submit value='$text{'save'}'>\n";
print "<input type=reset value='$text{'newweb_undo'}'>\n";
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

