#!/usr/local/bin/perl
# import_form.cgi
# Display a form for importing an existing mail domain, dns zone, apache
# virtual host and mysql database so that they can be controlled by this module.

require './virtual-server-lib.pl';
$access{'create'} && $access{'import'} || &error($text{'import_ecannot'});

&header($text{'import_title'}, "");
print "<hr>\n";

print "$text{'import_desc1'}<p>\n";
print "$text{'import_desc2'}<p>\n";
print "$text{'import_desc3'}<p>\n";

print "<form action=import.cgi method=post>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'import_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'import_dom'}</b></td>\n";
print "<td colspan=3><input name=dom size=40></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'import_user'}</b></td> <td colspan=3>\n";
print "<input type=radio name=user_def value=1> $text{'import_ucr'}<br>\n";
print "<input type=radio name=user_def value=0 checked> $text{'import_uex'}\n";
print &unix_user_input("user"),"</td>\n";

print "<tr> <td valign=top><b>$text{'import_group'}</b></td> <td colspan=3>\n";
print "<input type=radio name=group_def value=1> $text{'import_gdf'}<br>\n";
print "<input type=radio name=group_def value=0 checked> $text{'import_gex'}\n";
print &unix_group_input("group"),"</td>\n";

print "<tr> <td><b>$text{'import_pass'}</b></td>\n";
print "<td><input name=pass size=20 type=password></td> </tr>\n";

print "<tr> <td><b>$text{'import_webmin'}</b></td>\n";
print "<td><input type=radio name=webmin value=1 checked> $text{'yes'}\n";
print "<input type=radio name=webmin value=0> $text{'no'}</td>\n";

print "<td><b>$text{'import_db'}</b></td>\n";
print "<td><input name=db size=20></td> </tr>\n";

$defip = &get_default_ip();
print "<tr> <td><b>$text{'import_ip'}</b></td>\n";
print "<td><input name=ip size=15 value='$defip'></td>\n";

print "<td><b>$text{'import_hasvirt'}</b></td>\n";
print "<td><input type=radio name=virt value=1> $text{'yes'}";
print "<input type=radio name=virt value=0 checked> $text{'no'}</td> </tr>\n";

if ($config{'home_quotas'}) {
	print "<tr> <td><b>$text{'form_quota'}</b></td>\n";
	@defquota = split (/ /,$config{'defquota'});
	if ( !@defquota or $#defquota eq 0 ) {
	    print "<td>",&quota_input("quota", $config{'defquota'},
				      $config{'home_quotas'}),"</td>\n";
	} else {
	    print "<td><select name=quota>\n";
	    foreach $i (@defquota) {
		chomp $i;
		print "<option value=\"$i\">$i</option>\n";
	        }
	    print "<option value=\"-1\">$text{'other'}</option></select>\n";
	    print &quota_input("otherquota", "",
			       $config{'home_quotas'}),"</td>\n";
	    }
	print "</tr>\n";
	}

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'import_show'}'></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

