#!/usr/local/bin/perl
# index.cgi
# List all webmin users

require './acl-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);

@glist = &list_groups();
foreach $g (@glist) {
	foreach $gm (@{$g->{'members'}}) {
		$ingroup{$gm} = $g;
		}
	}

@ulist = &list_users();
foreach $u (@ulist) {
	$me = $u if ($u->{'name'} eq $base_remote_user);
	}
@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
	$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
			       &list_modules();
map { $mcan{$_}++ } @mcan;

if ($config{'order'}) {
	@ulist = sort { $a->{'name'} cmp $b->{'name'} } @ulist;
	@glist = sort { $a->{'name'} cmp $b->{'name'} } @glist;
	}

foreach $m (&list_module_infos()) {
	$modname{$m->{'dir'}} = $m->{'desc'};
	}
foreach $u (@ulist) {
	next if (!&can_edit_user($u->{'name'}, \@glist));
	if (!$header) {
		print "<hr>\n";
		print "<h3>$text{'index_users'}</h3>\n";
		print "<a href=edit_user.cgi>$text{'index_create'}</a>\n"
			if ($access{'create'});
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'index_user'}</b></td>\n";
		print "<td><b>$text{'index_modules'}</b></td> </tr>\n";
		$header++;
		}
	print "<tr $cb>\n";
	printf "<td valign=top><a href=\"edit_user.cgi?user=%s\">%s</a></td>\n",
		&urlize($u->{'name'}), $u->{'name'};
	if ($ingroup{$u->{'name'}}) {
		# Is a member of a group
		&show_modules("user", $u->{'name'}, $u->{'ownmods'}, 0,
			      &text('index_modgroups',
				  "<tt>$ingroup{$u->{'name'}}->{'name'}</tt>"));
			      
		}
	else {
		# Is a stand-alone user
		&show_modules("user", $u->{'name'}, $u->{'modules'}, 1);
		}
	}
if ($header) {
	print "</table>\n";
	print "<a href=edit_user.cgi>$text{'index_create'}</a>\n"
		if ($access{'create'});
	}
elsif ($access{'create'}) {
	print "<hr>\n";
	print "<h3>$text{'index_users'}</h3>\n";
	print "<b>$text{'index_nousers'}</b><p>\n";
	print "<a href=edit_user.cgi>$text{'index_create'}</a>\n";
	}
print "<p>\n";

if ($access{'groups'}) {
	print "<hr>\n";
	print "<h3>$text{'index_groups'}</h3>\n";
	foreach $g (@glist) {
		if (!$gheader) {
			print "<a href=edit_group.cgi>$text{'index_gcreate'}</a><br>\n";
			print "<table border width=100%>\n";
			print "<tr $tb> <td><b>$text{'index_group'}</b></td>\n";
			print "<td><b>$text{'index_members'}</b></td>\n";
			print "<td><b>$text{'index_modules'}</b></td> </tr>\n";
			$gheader++;
			}
		print "<tr $cb> <td valign=top>\n";
		printf "<a href='edit_group.cgi?group=%s'>%s</a></td>\n",
			&urlize($g->{'name'}), $g->{'name'};
		print "<td valign=top>",join(" ", @{$g->{'members'}}),
		      "&nbsp;</td>\n";

		if ($ingroup{$g->{'name'}}) {
			# Is a member of some other group
			&show_modules("group", $g->{'name'}, $g->{'ownmods'},0,
				&text('index_modgroups',
			          "<tt>$ingroup{$g->{'name'}}->{'name'}</tt>"));
			}
		else {
			# Is a top-level group
			&show_modules("group", $g->{'name'}, $g->{'modules'},1);
			}
		}
	if ($gheader) {
		print "</table>\n";
		}
	else {
		print "<b>$text{'index_nogroups'}</b><p>\n";
		}
	print "<a href=edit_group.cgi>$text{'index_gcreate'}</a><p>\n";
	}

&get_miniserv_config(\%miniserv);
if ($access{'sync'} && &foreign_check("useradmin")) {
	push(@icons, "images/convert.gif");
	push(@links, "convert_form.cgi");
	push(@titles, $text{'index_convert'});
	}
if ($access{'sync'} && $access{'create'} && $access{'delete'}) {
	push(@icons, "images/sync.gif");
	push(@links, "edit_sync.cgi");
	push(@titles, $text{'index_sync'});
	}
if ($access{'unix'} && $access{'create'} && $access{'delete'}) {
	push(@icons, "images/unix.gif");
	push(@links, "edit_unix.cgi");
	push(@titles, $text{'index_unix'});
	}
if ($access{'sessions'} && $miniserv{'session'}) {
	push(@icons, "images/sessions.gif");
	push(@links, "list_sessions.cgi");
	push(@titles, $text{'index_sessions'});
	}
if (uc($ENV{'HTTPS'}) eq "ON" && $miniserv{'ca'}) {
	push(@icons, "images/cert.gif");
	push(@links, "cert_form.cgi");
	push(@titles, $text{'index_cert'});
	}

if (@icons) {
	print "<hr>\n";
	&icons_table(\@links, \@titles, \@icons, scalar(@links));
	}

print "<hr>\n";
&footer("/", $text{'index'});

# show_modules(type, who, &mods, show-global, prefix)
sub show_modules
{
local ($type, $who, $mods, $global, $prefix) = @_;
if ($config{'select'}) {
	# Show as drop-down menu
	print "<form action=edit_acl.cgi>\n";
	print "<td>\n";
	print $prefix,"<br>\n" if ($prefix);
	if (@$mods) {
		print "<input type=hidden name=$type value='$who'>\n";
		if ($access{'acl'}) {
			print "<input type=submit value='$text{'index_edit'}'>\n";
			}
		print "<select name=mod>\n";
		print "<option value=''>$text{'index_global'}\n" if ($global);
		foreach $m (sort { $modname{$a} cmp $modname{$b} } @$mods) {
			if ($modname{$m}) {
				print "<option value=$m>$modname{$m}\n";
				}
			}
		print "</select>\n";
		}
	print "</td></form> </tr>\n";
	}
else {
	# Show as table
	print "<td>\n";
	print $prefix,"<br>\n" if ($prefix);
	print "<table width=100% cellpadding=1 cellspacing=1>\n";
	print "<tr> <td width=33%>\n";
	if ($access{'acl'}) {
		print "<a href='edit_acl.cgi?mod=&$type=",
		      &urlize($who),"'>$text{'index_global'}</a></td>";
		$done = 1;
		}
	foreach $m (sort { $modname{$a} cmp $modname{$b} } @$mods) {
		if ($modname{$m}) {
			if ($done%3 == 0) { print "<tr>\n"; }
			print "<td width=33%>";
			if ($mcan{$m} && $access{'acl'}) {
				print "<a href='edit_acl.cgi?mod=",
				      &urlize($m),"&$type=",&urlize($who),
				      "'>$modname{$m}</a>";
				}
			else {
				print $modname{$m};
				}
			print "</td>\n";
			if ($done%3 == 2) { print "<tr>\n"; }
			$done++;
			}
		}
	while($done++ % 3) { print "<td width=33%></td>\n"; }
	print "</table>\n";
	print "</td> </tr>\n";
	}
}
