#!/usr/local/bin/perl
# view.cgi
# Show details of the action, including changed files

require './webminlog-lib.pl';
&ReadParse();

# find the log record to view
$act = &get_action($in{'id'});
if (-r "../$act->{'module'}/log_parser.pl") {
	&foreign_require($act->{'module'}, "log_parser.pl");
	$parser++;
	}
&can_user($act->{'user'}) || &error($text{'view_ecannot'});
&can_mod($act->{'module'}) || &error($text{'view_ecannot'});

# display info about the action
&ui_print_header(undef, $text{'view_title'}, "");
print "<table border width=100%>\n";
print "<tr $tb> <td><b>",&text('view_header', $act->{'id'}),"</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

$d = &foreign_call($act->{'module'}, "parse_webmin_log",
		   $act->{'user'}, $act->{'script'},
		   $act->{'action'}, $act->{'type'},
		   $act->{'object'}, $act->{'param'}, 1) if ($parser);
print "<tr> <td valign=top><b>$text{'view_action'}</b></td>\n";
if ($d) {
	print "<td colspan=3>$d</td> </tr>\n";
	}
elsif ($act->{'action'} eq '_config_') {
	print "<td colspan=3>$text{'search_config'}</td> </tr>";
	}
else {
	printf "<td colspan=3>%s %s %s</td> </tr>\n",
		$act->{'action'}, $act->{'type'} ? $act->{'type'} : '',
		$act->{'object'};
	}

print "<tr> <td><b>$text{'view_module'}</b></td>\n";
%minfo = &get_module_info($act->{'module'});
print "<td>$minfo{'desc'}</td>\n";

print "<td><b>$text{'view_script'}</b></td>\n";
print "<td><tt>$act->{'module'}/$act->{'script'}</tt></td> </tr>\n";

print "<tr> <td><b>$text{'view_user'}</b></td>\n";
print "<td>$act->{'user'}</td>\n";

print "<td><b>$text{'view_ip'}</b></td>\n";
print "<td>$act->{'ip'}</td> </tr>\n";

print "<tr>\n";
if ($act->{'sid'} ne '-') {
	print "<td><b>$text{'view_sid'}</b></td>\n";
	print "<td><a href='search.cgi?sid=$act->{'sid'}&uall=1&mall=1&tall=1&fall=1&return=",&urlize($in{'return'}),"&returndesc=",&urlize($in{'returndesc'}),"'>$act->{'sid'}</a></td>\n";
	}
@tm = localtime($act->{'time'});
print "<td><b>$text{'view_time'}</b></td>\n";
printf "<td>%2.2d/%s/%4.4d %2.2d:%2.2d:%2.2d</td> </tr>\n",
	$tm[3], $text{"smonth_".($tm[4]+1)}, $tm[5]+1900,
	$tm[2], $tm[1], $tm[0];

if ($act->{'webmin'}) {
	print "<tr> <td><b>$text{'view_host'}</b></td>\n";
	print "<td>$act->{'webmin'}</td> </tr>\n";
	}

print "</table></td></tr></table><p>\n";

# display modified files
foreach $d (&list_diffs($act)) {
	local $t = $text{"view_type_".$d->{'type'}};
	if ($t =~ /\$2/ || !$d->{'diff'}) {
		# Diff is just a single line message
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>",
		      &text("view_type_".$d->{'type'},
			    "<tt>$d->{'object'}</tt>",
			    "<tt>".&html_escape($d->{'diff'})."</tt>"),"</b></td> </tr>\n";
		print "</table><p>\n";
		}
	else {
		# Show multi-line diff
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>",&text("view_type_".$d->{'type'},
		      "<tt>$d->{'object'}</tt>"),"</b></td> </tr>\n";
		print "<tr $cb> <td><pre>";
		print &html_escape($d->{'diff'});
		print "</pre></td> </tr>\n";
		if ($d->{'input'}) {
			# And input too
			print "<tr $tb> <td><b>",&text('view_input'),
			      "</b></td> </tr>\n";
			print "<tr $cb> <td><pre>";
			print &html_escape($d->{'input'});
			print "</pre></td> </tr>\n";
			}
		print "</table><p>\n";
		}
	$anydiffs++;
	}

print "<b>$text{'view_nofiles'}</b><p>\n" if (!$anydiffs);

# Show rollback button
@files = &list_files($act);
if (@files) {
	print &ui_buttons_start();
	print &ui_buttons_row("rollback.cgi",
			      $text{'view_rollback'},
			      $text{'view_rollbackdesc'},
			      &ui_hidden("id", $in{'id'}));
	print &ui_buttons_end();
	}

&ui_print_footer($ENV{'HTTP_REFERER'}, $text{'search_return'},
	"", $text{'index_return'});


