# webminlog-lib.pl
# XXX file rollback
#	XXX should we capture all files, or just those changed?
#	XXX what about commands?

do '../web-lib.pl';
&init_config();
do '../ui-lib.pl';
%access = &get_module_acl();
%access_mods = map { $_, 1 } split(/\s+/, $access{'mods'});
%access_users = map { $_, 1 } split(/\s+/, $access{'users'});

sub parse_logline
{
if ($_[0] =~ /^(\d+)\.(\S+)\s+\[.*\]\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+"([^"]+)"\s+"([^"]+)"\s+"([^"]+)"(.*)/ ||
    $_[0] =~ /^(\d+)\.(\S+)\s+\[.*\]\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)(.*)/) {
	local $rv = { 'time' => $1, 'id' => "$1.$2",
		      'user' => $3, 'sid' => $4,
		      'ip' => $5, 'module' => $6,
		      'script' => $7, 'action' => $8,
		      'type' => $9, 'object' => $10 };
	local %param;
	local $p = $11;
	while($p =~ /^\s*([^=\s]+)='([^']*)'(.*)$/) {
		if (defined($param{$1})) {
			$param{$1} .= "\0".$2;
			}
		else {
			$param{$1} = $2;
			}
		$p = $3;
		}
	foreach $k (keys %param) {
		$param{$k} =~ s/%(..)/pack("c",hex($1))/ge;
		}
	$rv->{'param'} = \%param;
	if ($rv->{'script'} =~ /^(\S+):(\S+)$/) {
		$rv->{'script'} = $2;
		$rv->{'webmin'} = $1;
		}
	return $rv;
	}
else {
	return undef;
	}
}

# list_diffs(&action)
# Returns details of file changes made by this action
sub list_diffs
{
local $i = 0;
local @rv;
while(open(DIFF, "$ENV{'WEBMIN_VAR'}/diffs/$act->{'id'}.$i")) {
        local ($type, $object, $diff, $input);
        local $line = <DIFF>;
        while(<DIFF>) { $diff .= $_; }
        close(DIFF);
	if ($line =~ /^(\/.*)/) {
                $type = 'modify'; $object = $1;
                }
        elsif ($line =~ /^(\S+)\s+(.*)/) {
                $type = $1; $object = $2;
                }
	if ($type eq "exec") {
		open(INPUT, "$ENV{'WEBMIN_VAR'}/diffs/$act->{'id'}.$i.input");
		while(<INPUT>) {
			$input .= $_;
			}
		close(INPUT);
		}
	push(@rv, { 'type' => $type,
		    'object' => $object,
		    'diff' => $diff,
		    'input' => $input } );
	$i++;
	}
return @rv;
}

# list_files(&action)
# Returns details of original files before this action was taken
sub list_files
{
local $i = 0;
local @rv;
while(open(FILE, "$ENV{'WEBMIN_VAR'}/files/$act->{'id'}.$i")) {
        local ($type, $object, $data);
        local $line = <FILE>;
	$line =~ s/\r|\n//g;
        while(<FILE>) { $data .= $_; }
        close(FILE);
	if ($line =~ /^(\S+)\s+(.*)/) {
		$type = $1;
		$file = $2;
		}
	elsif ($line =~ /^\s+(.*)/) {
		$type = -1;
		$file = $1;
		}
	else {
		next;
		}
	push(@rv, { 'type' => $type,
		    'file' => $file,
		    'data' => $data });
	$i++;
	}
return @rv;
}

# can_user(username)
sub can_user
{
return $access_users{'*'} || $access_users{$_[0]};
}

# can_mod(module)
sub can_mod
{
return $access_mods{'*'} || $access_mods{$_[0]};
}

# get_action(id)
# Returns the structure for some action
sub get_action
{
local $act;
open(LOG, $webmin_logfile);
while(<LOG>) {
	if (($act = &parse_logline($_)) && $act->{'id'} eq $_[0]) {
		return $act;
		}
	}
close(LOG);
return undef;
}

1;

