#!/usr/local/bin/perl
# index.cgi
# Display a list of all existing processes

require './proc-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", "tree", !$no_module_config, 1);

&index_links("tree");
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'pid'}</b></td> <td><b>$text{'owner'}</b></td>\n";
if ($info_arg_map{'_stime'}) {
	print "<td><b>$text{'stime'}</b></td>\n";
	}
print "<td><b>$text{'command'}</b></td> </tr>\n";
@procs = sort { $a->{'pid'} <=> $b->{'pid'} } &list_processes();
foreach $pr (@procs) {
	$p = $pr->{'pid'}; $pp = $pr->{'ppid'};
	$argmap{$p} = $pr->{'args'};
	$usermap{$p} = $pr->{'user'};
	$stimemap{$p} = $pr->{'_stime'};
	push(@{$children{$pp}}, $p);
	$inlist{$pr->{'pid'}}++;
	}
foreach $pr (@procs) {
	push(@roots, $pr->{'pid'}) if (!$inlist{$pr->{'ppid'}} ||
				       $pr->{'pid'} == $pr->{'ppid'} ||
				       $pr->{'pid'} == 0);
	}
foreach $r (&unique(@roots)) {
	&walk_procs("", $r);
	}
print "</table><p>\n";

&ui_print_footer("/", $text{'index'});


# walk_procs(indent, pid)
sub walk_procs
{
next if ($done_proc{$_[1]}++);
local(@ch, $_, $args);
if (&can_view_process($usermap{$_[1]})) {
	if (&can_edit_process($usermap{$_[1]})) {
		print "<tr $cb><td>$_[0]<a href=\"edit_proc.cgi?$_[1]\">",
		      "$_[1]</a></td>\n";
		}
	else {
		print "<tr $cb> <td>$_[0]$_[1]</td>\n";
		}
	print "<td>$usermap{$_[1]}</td>\n";
	if ($info_arg_map{'_stime'}) {
		print "<td>",$stimemap{$_[1]} || "<br>","</td>\n";
		}
	$args = &cut_string($argmap{$_[1]});
	print "<td>",&html_escape($args),"</td> </tr>\n";
	}
foreach (@{$children{$_[1]}}) {
	&walk_procs("$_[0]&nbsp;&nbsp;&nbsp;", $_);
	}
}

