#!/usr/local/bin/perl
# index.cgi
# Display syslog rules

require './syslog-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("syslog", "man", "doc"));

if ($config{'m4_conf'}) {
	# Does the config file need to be passed through m4?
	if (&needs_m4()) {
		# syslog.conf has m4 directives .. ask the user if he wants
		# to filter the file
		print "<p>",&text('index_m4msg',
				  "<tt>$config{'syslog_conf'}</tt>"),"\n";
		print "<center><form action=m4.cgi>\n";
		print "<input type=submit value='$text{'index_m4'}'>\n";
		print "</form></center>\n";
		&ui_print_footer("/", $text{'index'});
		exit;
		}
	}

if (!-r $config{'syslog_conf'}) {
	# Not installed (maybe using syslog-ng)
	&ui_print_endpage(&text('index_econf', "<tt>$config{'syslog_conf'}</tt>", "../config.cgi?$module_name"));
	}

# Display syslog rules
$conf = &get_config();
print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a><br>\n"
	if (!$access{'noedit'});
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_to'}</b></td> ",
      $config{'tags'} ? "<td><b>$text{'index_tag'}</b></td>" : "",
      "<td><b>$text{'index_active'}</b></td> ",
      "<td colspan=2><b>$text{'index_rule'}</b></td> </tr>\n";
foreach $c (@$conf) {
	next if ($c->{'tag'});
	next if (!&can_edit_log($c));
	print "<tr $cb> <td>\n";
	print "<a href='edit_log.cgi?idx=$c->{'index'}'>"
		if (!$access{'noedit'});
	if ($c->{'file'}) {
		print &text('index_file',
			"<tt>".&html_escape($c->{'file'})."</tt>");
		}
	elsif ($c->{'pipe'} && $config{'pipe'} == 1) {
		print &text('index_pipe',
			"<tt>".&html_escape($c->{'pipe'})."</tt>");
		}
	elsif ($c->{'pipe'} && $config{'pipe'} == 2) {
		print &text('index_pipe2',
			"<tt>".&html_escape($c->{'pipe'})."</tt>");
		}
	elsif ($c->{'host'}) {
		print &text('index_host',
			"<tt>".&html_escape($c->{'host'})."</tt>");
		}
	elsif ($c->{'socket'}) {
		print &text('index_socket',
			"<tt>".&html_escape($c->{'socket'})."</tt>");
		}
	elsif ($c->{'all'}) {
		print $text{'index_all'};
		}
	else {
		print &text('index_users',
			"<tt>".join(" ", map { &html_escape($_) }
					 @{$c->{'users'}})."</tt>");
		}
	print "</a>\n" if (!$access{'noedit'});
	print "</td>\n";
	if ($config{'tags'}) {
		printf "<td>%s</td>\n",
			$c->{'section'}->{'tag'} eq '*'
			? $text{'all'} : $c->{'section'}->{'tag'};
		}
	print "<td>",$c->{'active'} ? $text{'yes'}
				    : "<font color=#ff0000>$text{'no'}</font>",
	      "</td> <td>\n";
	print join("&nbsp;;&nbsp;",
		   map { &html_escape($_) } @{$c->{'sel'}});
	print "</td> <td width=10>\n";
	if ($c->{'file'} && -f $c->{'file'}) {
		print "<a href='save_log.cgi?idx=$c->{'index'}&",
		      "view=1'>$text{'index_view'}</a>\n";
		}
	else { print "<br>\n"; }
	print "</td> </tr>\n";
	}
print "</table>\n";
print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a>\n"
	if (!$access{'noedit'});
print "<p>\n";

if (!$access{'noedit'}) {
	print "<hr>\n";
	$pid = &get_syslog_pid();
	if ($pid) {
		print "<form action=restart.cgi>\n";
		print "<table width=100%><tr>\n";
		print "<input type=hidden name=pid value='$pid'>\n";
		print "<td><input type=submit value='$text{'index_restart'}'></td>\n";
		print "<td>$text{'index_restartmsg'}</td>\n";
		print "</tr></table></form>\n";
		}
	else {
		print "<form action=start.cgi>\n";
		print "<table width=100%><tr>\n";
		print "<td><input type=submit value='$text{'index_start'}'></td>\n";
		print "<td>",&text('index_startmsg', "<tt>$config{'syslogd'}</tt>"),
		      "</td>\n";
		print "</tr></table></form>\n";
		}
	close(PID);
	}

&ui_print_footer("/", $text{'index'});

