#!/usr/local/bin/perl
# edit_proxy.cgi
# Proxy servers config form

require './webmin-lib.pl';
&ui_print_header(undef, $text{'proxy_title'}, "");

print $text{'proxy_desc'},"<p>\n";

print "<form action=change_proxy.cgi>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'proxy_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td nowrap><b>$text{'proxy_http'}</b></td>\n";
printf "<td nowrap><input type=radio name=http_def value=1 %s> %s\n",
	$gconfig{'http_proxy'} ? "" : "checked", $text{'proxy_none'};
printf "<input type=radio name=http_def value=0 %s> \n",
	$gconfig{'http_proxy'} ? "checked" : "";
printf "<input name=http size=35 value=\"%s\"></td> </tr>\n",
	$gconfig{'http_proxy'};

print "<tr> <td nowrap><b>$text{'proxy_ftp'}</b></td>\n";
printf "<td nowrap><input type=radio name=ftp_def value=1 %s> %s\n",
	$gconfig{'ftp_proxy'} ? "" : "checked", $text{'proxy_none'};
printf "<input type=radio name=ftp_def value=0 %s> \n",
	$gconfig{'ftp_proxy'} ? "checked" : "";
printf "<input name=ftp size=35 value=\"%s\"></td> </tr>\n",
	$gconfig{'ftp_proxy'};

print "<tr> <td nowrap><b>$text{'proxy_nofor'}</b></td>\n";
printf "<td nowrap><input name=noproxy size=40 value=\"%s\"></td> </tr>\n",
	$gconfig{'noproxy'};

print "<tr> <td nowrap><b>$text{'proxy_user'}</b></td>\n";
printf "<td><input name=puser size=20 value='%s'></td> </tr>\n",
	$gconfig{'proxy_user'};
print "<tr> <td nowrap><b>$text{'proxy_pass'}</b></td>\n";
printf "<td><input type=password name=ppass size=20 value='%s'></td> </tr>\n",
	$gconfig{'proxy_pass'};

print "<tr> <td nowrap><b>$text{'proxy_bind'}</b></td>\n";
printf "<td nowrap><input type=radio name=bind_def value=1 %s> %s\n",
	$gconfig{'bind_proxy'} ? "" : "checked", $text{'default'};
printf "<input type=radio name=bind_def value=0 %s> \n",
	$gconfig{'bind_proxy'} ? "checked" : "";
printf "<input name=bind size=35 value=\"%s\"></td> </tr>\n",
	$gconfig{'bind_proxy'};

print "</table></td></tr></table>\n";
print "<input type=submit value=\"$text{'save'}\"></form>\n";

# OSDN mirror form
print $text{'proxy_desc2'},"<p>\n";
print &ui_form_start("change_osdn.cgi");
print &ui_table_start($text{'proxy_header2'}, undef, 2);

if ($config{'osdn'}) {
	# Show list of mirrors to choose from
	$base = &get_webmin_base_version();
	@mirrors = &list_osdn_mirrors("webadmin", "webmin-$base.tar.gz");
	@codes = map { $_->{'mirror'} } @mirrors;
	$inlist = !$gconfig{'osdn_mirror'} ||
		  &indexof($gconfig{'osdn_mirror'}, @codes) >= 0;
	print &ui_table_row($text{'proxy_osdn'},
	   &ui_select("mirror", $inlist ? $gconfig{'osdn_mirror'} : "*",
			[ [ "", $text{'proxy_mirrordef'} ],
			  (map { [ $_->{'mirror'},
				   $_->{'country'} ? "$_->{'mirror'} ($_->{'country'}, $_->{'continent'})" : $_->{'mirror'} ] } @mirrors),
			  [ "*", $text{'proxy_other'} ] ])." ".
		     &ui_textbox("other",
			$inlist ? "" : $gconfig{'osdn_mirror'}, 10));
	}
else {
	# Just show text field for mirror code
	print &ui_table_row($text{'proxy_osdn'},
	   &ui_opt_textbox("mirror", $gconfig{'osdn_mirror'}, 10,
			      $text{'proxy_mirrordef2'}));
	}
print &ui_table_end();
print &ui_form_end([ [ "save", $text{'save'} ] ]);

&ui_print_footer("", $text{'index_return'});

