#!/usr/bin/perl
#
# auth-pop.pl: Password changing with the Qualcomm poppassd server
# ftp.qualcomm.com:/quest/unix/servers/password
# contributed BY Gary Mills
# History:
# 4 Jun 01 Created
# 5 Jun 01 Fixed a response handling bug
 
use IO::Socket::INET;

$useauth=1;

sub auth_disconnect {
    return 0;
}

sub auth_getuserserver {
       return '';
}


sub auth_changepass {
	
#  Lets Check the Password

    my $pass1 = param("pass1");
    my $pass2 = param("pass2");
    if (!$pass1 && !$pass2) {return;}
    if ($pass1 eq "" || $pass2 eq "") {return;}

    if ($pass1 ne $pass2) {
	print "<b>Error:</b> Passwords Did Not Match...Not Changed...\n",p;
	exit;
    }
    else {
	my $sock = IO::Socket::INET->new(
					 Proto    => "tcp",
					 PeerAddr => "localhost",
					 PeerPort => "poppassd(106)",
					 );
	unless ($sock) {
	    print "\n",p,"Error: Unable to connect to poppassd\n",p;
	    exit;
	}
	my $resp = <$sock>;
	if (substr($resp, 0, 12)  eq "200 poppassd") {
	    print $sock "user $uid\r\n";
	    $resp = <$sock>;
	    if (substr ($resp, 0, 3) eq "200") {
		print $sock "pass $pass\r\n";
		$resp = <$sock>;
		if (substr ($resp, 0, 3) eq "200") {
		    print $sock "newpass $pass1\r\n";
		    $resp = <$sock>;
		    if (substr ($resp, 0, 3) eq "200") {
			$resp = '999';
		    }
		}
	    }
	}

    }
    $resp="000 unexpected EOF" unless $resp;
    unless ($resp eq '999') {
        print "\n",p,"Error from poppassd: $resp\n",p;
	exit;
    }
	  
#  Success!
    print "<b>Password Modified...</b>\n";
    print "<b>Warning:</b> You must login with your new password by clicking <a href=" . $program_url . "?op=logout>HERE</a>\n",p;
    exit;

}
1;
