/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WFLOGENTRY_H
#define _WFLOGENTRY_H

#include <iostream>
#include <string>
#include <netinet/in.h> /* for IPPROTO_* */
#include <sys/types.h> /* for *_int* */

#include "wfipaddr.h"
#include "wfmacaddr.h"

/* TCP flags */
#define TCP_FIN 0x01
#define TCP_SYN 0x02
#define TCP_RST 0x04
#define TCP_PSH 0x08
#define TCP_ACK 0x10
#define TCP_URG 0x20
#define TCP_ECE 0x40
#define TCP_CWR 0x80

/**
 * 
 */
class wf_logentry {
 public:
  wf_logentry();
  virtual ~wf_logentry() {}
  // wf_logentry(const wf_logentry&) implicit copy constructor
  virtual wf_logentry* VClone() const;

  bool check() const;

  string tcpflags_tostr() const;
  string tcpflags_tostr_mini() const;

  ostream& debugprint(ostream& os) const;

 public:
  /* format: name of the tool which generated this entry.
     Can be empty. */
  string format;

  /* count: number of log lines represented by this entry.
     Must be > 0. */
  unsigned int count;

  /* start_time: date of the logged packet if count == 1,
     or date of the first log line represented by this entry if count > 1.
     Must be != 0. */
  time_t start_time;
  /* end_time: date of the last log line represented by this entry if
     count > 1.
     Must be == 0 if count == 1. */
  time_t end_time;

  /* hostname: name of the host which produced the log entry.
     Can be empty. */
  string hostname;
  /* chainlabel: name of the chain label. Depends on the firewalling tool.
     Can be empty. */
  string chainlabel;
  /* branchname: string depending on the firewalling tool.
     Can be empty. */
  string branchname;

  /* input_iface: input interface name.
     Can be empty if output_iface is not empty. */
  string input_iface;
  /* output_iface: input interface name.
     Can be empty if input_iface is not empty. */
  string output_iface;

  /* protocol: protocol number (see /etc/protocols).
     Must be >= 0 (protocol == -1 when not initialised). */
  int16_t protocol;

  /* datalen: data len of the packet.
     Can be 0 if undefined. */
  u_int32_t datalen;

  /* sipaddr: source IP address.
     Must be defined. */
  wf_ipaddr sipaddr;
  /* sport: source port.
     If protocol == TCP|UDP, must be > 0.
     If protocol == ICMP, sport contains ICMP type.
     Must be == 0 otherwise. */
  u_int16_t sport;
  /* smacaddr: source MAC address.
     Defined only if available. */
  wf_macaddr smacaddr;

  /* dipaddr: destination IP address.
     Must be defined. */
  wf_ipaddr dipaddr;
  /* dport: destination port.
     If protocol == TCP|UDP, must be > 0.
     If protocol == ICMP, dport contains ICMP code (if icmp type needs it).
     Must be == 0 otherwise. */
  u_int16_t dport;
  /* dmacaddr: destination MAC address.
     Defined only if available. */
  wf_macaddr dmacaddr;

  /* tcpflags: if protocol == TCP, contains TCP flags.
     Must be == 0 otherwise. */
  u_int16_t tcpflags;
};

inline wf_logentry*
wf_logentry::VClone() const {
  return new wf_logentry(*this);
}

#endif
