/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <netdb.h>
#include <sys/socket.h>  /* for AF_INET */
#include <netinet/in.h>  /* for htons */

#include "resolv.h"
#include "defs.h"


string
resolv_service(int port, const string& proto) {
  struct servent* servent;

  servent = getservbyport(htons(port), proto.c_str());
  if (servent != NULL)
    return servent->s_name;
  
  return "";
}

string
resolv_hostname(const wf_ipaddr& ipaddr) {
#if 0
  struct hostent *reverse, *forward;
  struct dns_cache *dns;
  char *pnt;

  dns = dns_first;
  while (dns != NULL) {
    if (ip.s_addr == dns->ip.s_addr) {
      if (opt.verbose) {
	fprintf(stderr, _("Resolving %s from cache\n"), inet_ntoa(ip));
      }
      return dns->fqdn;
    }
    dns = dns->next;
  }

  if (opt.verbose)
    fprintf(stderr, _("Resolving %s\n"), inet_ntoa(ip));

  reverse = gethostbyaddr((void *)&ip.s_addr, sizeof(struct in_addr), AF_INET);

  dns = xmalloc(sizeof(struct dns_cache));
  dns->ip.s_addr = ip.s_addr;

  if((reverse != NULL) && (reverse->h_name != NULL)) {
    if ((unsigned int)reverse->h_length > sizeof(struct in_addr)) {
      fprintf(stderr, _("Wrong host name size\n"));
      reverse->h_length = sizeof(struct in_addr);
      reverse->h_name[reverse->h_length] = '\0';
    }

    pnt = reverse->h_name;
    while (*pnt != '\0') {
      if (isalnum((int)*pnt) || *pnt == '.' || *pnt == '-') {
	pnt++;
	continue;
      } else {
	*pnt = '_';
	pnt++;
      }
    }

    if (opt.verbose)
      fprintf(stderr, _("Resolving %s\n"), reverse->h_name);

    forward = gethostbyname(reverse->h_name);
    if ((forward != NULL) && (forward->h_addr_list[0]) != NULL) {
      if (strncmp(inet_ntoa(ip), inet_ntoa(*(struct in_addr *)forward->h_addr_list[0]), IPLEN) == 0) {
	xstrncpy(dns->fqdn, reverse->h_name, HOSTLEN);
      } else {
	snprintf(dns->fqdn, HOSTLEN, _("%s [forward lookup: %s]"), reverse->h_name, inet_ntoa(*(struct in_addr *)forward->h_addr_list[0]));
      }
    } else {
      snprintf(dns->fqdn, HOSTLEN, _("%s [forward lookup failed]"), reverse->h_name);
    }
  } else {
    xstrncpy(dns->fqdn, "-", HOSTLEN);
  }

  dns->next = dns_first;
  dns_first = dns;

  return (dns->fqdn);

#else

  struct hostent* reverse;
  struct in_addr ip;
  ip.s_addr = ipaddr.get();
  reverse = gethostbyaddr((char*)&ip.s_addr, sizeof(struct in_addr), AF_INET);
  return (reverse != NULL && reverse->h_name != NULL) ? reverse->h_name : "";
#endif
}
