/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2003 Ron Steinke <rsteinke@w-link.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _CORNER_CONTAINER_H
#define _CORNER_CONTAINER_H

#include <wftk/singlecontainer.h>

namespace wftk {

/** 
 * A container which puts its single child in one of its corners.
 *
 * This is used in the terrain demos and the uclient map dialog
 * to put a 'close' button in the lower right corner of a dialog
 * whose entire purpose is to hold a drawing surface as its background.
 * More creative uses are probably possible.
 **/
class CornerContainer : public SingleContainer
{
 public:
  /** Corner enumeration defines four flages, one each for the diagonal
   * corners of a rectangle: \b TOP_LEFT, \b TOP_RIGHT, \b BOTTOM_LEFT, 
   * \b BOTTOM_RIGHT.
   */
  enum Corner {
   // some flags, so you can convieniently set up a corner
   LEFT = 1,
   RIGHT = 2,
   TOP = 4,
   BOTTOM = 8,
   // the constructor expects one of these
   TOP_LEFT = TOP | LEFT, 
   TOP_RIGHT = TOP | RIGHT, 
   BOTTOM_LEFT = BOTTOM | LEFT, 
   BOTTOM_RIGHT = BOTTOM | RIGHT 
  };

  /**
   * Constructor
   *
   *\param corner corner to put the button into. Defaults to bottom right.
   *\param hpad the horizontal padding in pixels. Defaults to 10.
   *\param vpad the vertical padding in picels. Defaults to 10.
   */
  CornerContainer(Corner corner = BOTTOM_RIGHT, unsigned hpad = 10, unsigned vpad = 10);

 protected:
  ///
  virtual void handleResize(Uint16 w, Uint16 h);
 private:
  Corner corner_;
  unsigned hpad_, vpad_;
};

} // namespace wftk

#endif // _CORNER_CONTAINER_H
