/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2003 Ron Steinke <rsteinke@w-link.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _FONT_DATA_H
#define _FONT_DATA_H

#include <wftk/font.h>

#include <ft2build.h>
#include FT_FREETYPE_H

namespace wftk {

// a wrapper around a freetype2 font face
class FontData
{
 public:
  FontData(const std::string& file, unsigned ptsize, unsigned face_index = 0)
	throw(Font::BadFont);
  FontData(const unsigned char* buffer, unsigned buf_size, unsigned ptsize,
	unsigned face_index = 0) throw(Font::BadFont);
  ~FontData();

  // glyph access
  FT_GlyphSlot operator[](unsigned char);

  const Font::Metrics& metrics() const {return metrics_;}

  Font::SurfaceTable* ref(const Color& color) {return map_.ref(color);}
  void unref(const Color& color) {map_.unref(color);}
  bool empty() const {return map_.empty();}

  bool hasKerning() const {return FT_HAS_KERNING(face_);}
  Point getKerning(unsigned char prev, unsigned char next) const;

 private:
  // unimplemented
  FontData(const FontData&);
  FontData& operator=(const FontData&);

  static FT_Library lib_;
  static unsigned long lib_refcount_;

  static void reflib() throw(Font::BadFont);
  static void unreflib() throw();

  // return horizontal and vertical dots per inch,
  // FIXME this is currently just the value for a 17"
  // monitor and 1024x768, need some way to auto-detect
  // this
  static Point getDPI() {return Point(80, 80);}

  FT_Face face_;

  Font::Metrics metrics_;

  void setMetrics();

  Font::MapType map_;
};

} // namespace

#endif
