/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux 

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// writtten May 1999



#ifndef _SOUND_H
#define _SOUND_H

#include <SDL/SDL_types.h>
#include <string>

namespace wftk {

/// abstract sound class
class Sound 
{

public:

  ///
  enum { VOLUME_MAX = 128, VOLUME_MIN = 0 };
  ///
  Sound() {}
  /// create a copy of a sound
  Sound(const Sound&) {}
  ///
  virtual ~Sound() {}
  
  /// load a sound from a file
  virtual bool load(const std::string&) = 0;
  /// is the sound currently playing?
  virtual bool playing() const = 0;
  /**set volume.
     valid range is 0..128, the old value is returned.
     if vol=-1, just the old value is returned.
  */
  virtual int setVolume(int vol) = 0;
  /// play the sound
  virtual bool play(int loops = 0) const = 0;
  /// stop playing the sound
  virtual void stop() const = 0;
};

}

#endif
