/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "togglebutton.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "keysym.h"

namespace wftk {

ToggleButton::ToggleButton()
{
  getResourceBackground("togglebutton");

  setUpPic("togglebutton_up_surface");
  setDownPic("togglebutton_down_surface");

  //repeating makes no sense here
  setRepeat(false);
}

ToggleButton::ToggleButton(const std::string& text, const Font &font) :
  PushButton(text, font)
{
  getResourceBackground("togglebutton");

  setUpPic("togglebutton_up_surface");
  setDownPic("togglebutton_down_surface");

  //repeating makes no sense here
  setRepeat(false);
}

bool
ToggleButton::buttonEvent(Mouse::Button button, bool pressed_val, const Point& pos)
{
  if(Widget::buttonEvent(button, pressed_val, pos))
    return true;

  if(button != Mouse::LEFT || !pressed_val) 
    return false;

 toggle();

 invalidate();

 return true;
}

bool
ToggleButton::keyEvent(const SDL_keysym& sym, bool pressed_val)
{
  if(Widget::keyEvent(sym, pressed_val))
    return true;

  if(!pressed_val)
    return false;

  char input = sym.unicode & 0x7f;

  if((input =='\n') || (input == '\r') || (input == ' '))
    {
      toggle();
      invalidate();		  
      return true;
    }

  if(sym.sym == (int) KEY_TAB)
    {
      if(sym.mod & KEY_MOD_SHIFT)
        Focus::instance()->prevFocus();
      else
        Focus::instance()->nextFocus();
      return true;
    }

  return false;
}

}
