/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _TOGGLEBUTTON_H
#define _TOGGLEBUTTON_H

#include <wftk/pushbutton.h>

namespace wftk {

/**ToggleButton.
   This class implements a different behavior to Button.
   The button stays pressed until it is clicked again.
   The autorepeat flag is ignored.
*/
class ToggleButton : public PushButton
{
 //OBJECT

 public:
  ///
  ToggleButton();
  /** 
   * Create a ToggleButton with the given text as a label
   *\param text text for the button label, defaults to empty string
   *\param font font to use for the text, defaults to "button_font"
   */
  explicit ToggleButton(const std::string& text,
			const Font &font=Font::registry.find("button_font"));

  /**
   * triggered when a button event happens
   *\param button which mouse button is producing the event
   *\param pressed_val is the button pressed or released
   *\param pos position of the cursor
   *\return true on a handled button even, false if it's unhandled, I think
   */
  virtual bool buttonEvent(Mouse::Button button, bool pressed_val, 
			   const Point& pos);
  /**
   * triggered when a keyboard event happens
   *\param sym SDL_keysym type, i.e. the key that triggered the event
   *\param pressed_val is the key pressed or released
   *\return true on handled key even, false otherwise
   */
  virtual bool keyEvent(const SDL_keysym& sym, bool pressed_val);
  /**
   * as opposed to the Button class, this does nothing
   */
  virtual void lostMouse() {}
  /**
   * as opposed to the Button class, this does nothing
   */
  virtual void lostFocus() {}
};

}
#endif // !_TOGGLEBUTTON

