#!/bin/bash

HERE=`dirname $0`
#TARGET=res_color
TARGET=res_bw

GIMP=$HOME/.gimp-1.2/scripts

if `test ! -d $GIMP`; then
  echo this script was made for gimp version 1.2, good luck 1>&2
  GIMP=$HOME/.gimp/scripts
fi

if `test ! -d $GIMP`; then
  echo did not found gimp script directory 1>&2
  exit 1 
fi

cp $HERE/inserticon.scm $GIMP

POSITION=`awk -v what=$1 '$1 ~ /NODE_/ {if (startcount) count++} /enum NodeEnum/ {startcount = 1} { if ($1 == what ",") {print count;exit(0)}}' $HERE/../src/Node.h`

if test "$POSITION" = "" ; then
   echo $1 not found in Node.h
   exit 1
fi

export ICON=\"$HERE/../src/res/node_icons.bmp\"
cp $HERE/../src/$TARGET/node_icons.bmp $HERE/../src/res/node_icons.bmp &&
gimp --no-data --verbose -b "(script-fu-new-duneInsertIcon-batch $ICON $POSITION)" 
#gimp --no-data --verbose -b "(script-fu-new-duneInsertIcon-batch $ICON $POSITION)" '(gimp-quit 0)' 
if test $? = 0 ;then
   cp $HERE/../src/res/node_icons.bmp $HERE/../src/$TARGET/node_icons.bmp
else
   echo gimp failed 1>&2
   exit 1
fi
