/*
 * Field.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _FIELD_H
#define _FIELD_H

#include "Element.h"
#include "Node.h"

class FieldValue;
class ExposedField;

enum {
    FF_HIDDEN	    = 1<<0,
    FF_FIXEDSTRINGS = 1<<1,
    FF_URL	    = 1<<2,
    FF_DELETED	    = 1<<3,
    EIF_RECOMMENDED = 1<<4,
    EOF_RECOMMENDED = 1<<5
};

class Field : public Element {
public:
		    Field(int type, const MyString &name,
			  FieldValue *value, ExposedField *exposedField = NULL,
			  FieldValue *min = NULL, FieldValue *max = NULL,
			  int nodeType = ANY_NODE, int flags = 0, 
			  const char **strings = NULL);
    virtual	   ~Field();
    virtual int     getElementType() const { return EL_FIELD_DEF; }
    virtual int     write(int filedes, int indent) const;
    const MyString &getName() const { return _name; }
    int		    getType() const { return _type; }
    FieldValue	   *getDefault() const { return _value; }
    ExposedField   *getExposedField() const { return _exposedField; }
    FieldValue     *getMin() const { return _min; }
    FieldValue     *getMax() const { return _max; }
    int		    getNodeType() const { return _nodeType; }
    void            addToNodeType(int nodeType);
    int		    getFlags() const { return _flags; }
    void	    setFlags(int flags) { _flags = flags; }
    const char    **getStrings() const { return _strings; }
    int             getEventIn() { return _eventIn; }
    void            setEventIn(int eventIn) { _eventIn = eventIn; } 

private:
    MyString	    _name;
    int		    _type;
    FieldValue	   *_value;
    ExposedField   *_exposedField;
    int             _eventIn;
    FieldValue	   *_min;
    FieldValue	   *_max;
    int		    _flags;
    int		    _nodeType;
    const char    **_strings;
};

#endif // _FIELD_H
