(**************************************************************************)
(*                                                                        *)
(*  The Why/Caduceus/Krakatoa tool suite for program certification        *)
(*  Copyright (C) 2002-2006                                               *)
(*    Jean-Franois COUCHOT                                               *)
(*    Mehdi DOGGUY                                                        *)
(*    Jean-Christophe FILLITRE                                           *)
(*    Thierry HUBERT                                                      *)
(*    Claude MARCH                                                       *)
(*    Yannick MOY                                                         *)
(*                                                                        *)
(*  This software is free software; you can redistribute it and/or        *)
(*  modify it under the terms of the GNU General Public                   *)
(*  License version 2, as published by the Free Software Foundation.      *)
(*                                                                        *)
(*  This software is distributed in the hope that it will be useful,      *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *)
(*                                                                        *)
(*  See the GNU General Public License version 2 for more details         *)
(*  (enclosed in the file GPL).                                           *)
(*                                                                        *)
(**************************************************************************)

open Creport
open Info
open Ctypes
open Clogic
open Cenv
open Cnorm

val add_predicates : 
  Cast.ndecl Cast.located list -> Cast.ndecl Cast.located list

val pred_for_type : 
  Cast.nctype -> Cast.nterm -> Cast.npredicate

val add_typing_predicates :
  Cast.ndecl Cast.located list -> Cast.ndecl Cast.located list

val function_for_int_type : Ctypes.sign * Ctypes.cinteger -> string

val min_int : Ctypes.sign * int -> string
val max_int : Ctypes.sign * int -> string

val min_cinteger : Ctypes.sign * Ctypes.cinteger -> string
val max_cinteger : Ctypes.sign * Ctypes.cinteger -> string
