(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Export Why.

(*Why logic*) Definition N : Z.
Admitted.

(*Why type*) Definition iset: Set.
Admitted.

(*Why logic*) Definition in_ : Z -> iset -> Prop.
Admitted.

(*Why predicate*) Definition included  (a:iset) (b:iset)
  := (forall (i:Z), ((in_ i a) -> (in_ i b))).

(*Why logic*) Definition card : iset -> Z.
Admitted.

(*Why axiom*) Lemma card_nonneg : (forall (s:iset), (card s) >= 0).
Admitted.
Dp_hint card_nonneg.

(*Why logic*) Definition empty : iset.
Admitted.

(*Why axiom*) Lemma empty_def : (forall (i:Z), ~(in_ i empty)).
Admitted.
Dp_hint empty_def.

(*Why axiom*) Lemma empty_card :
  (forall (s:iset), ((card s) = 0 <-> s = empty)).
Admitted.
Dp_hint empty_card.

(*Why logic*) Definition diff : iset -> iset -> iset.
Admitted.

(*Why axiom*) Lemma diff_def_1 :
  (forall (a:iset),
   (forall (b:iset),
    (forall (i:Z), ((in_ i (diff a b)) -> (in_ i a) /\ ~(in_ i b))))).
Admitted.
Dp_hint diff_def_1.

(*Why axiom*) Lemma diff_def_2 :
  (forall (a:iset),
   (forall (b:iset),
    (forall (i:Z), ((in_ i a) /\ ~(in_ i b) -> (in_ i (diff a b)))))).
Admitted.
Dp_hint diff_def_2.

(*Why logic*) Definition add : Z -> iset -> iset.
Admitted.

(*Why axiom*) Lemma add_def :
  (forall (s:iset),
   (forall (x:Z), (forall (i:Z), ((in_ i (add x s)) <-> i = x \/ (in_ i s))))).
Admitted.
Dp_hint add_def.

(*Why logic*) Definition remove : Z -> iset -> iset.
Admitted.

(*Why axiom*) Lemma remove_def :
  (forall (s:iset),
   (forall (x:Z),
    (forall (i:Z), ((in_ i (remove x s)) <-> (in_ i s) /\ i <> x)))).
Admitted.
Dp_hint remove_def.

(*Why axiom*) Lemma remove_card :
  (forall (s:iset),
   (forall (i:Z), ((in_ i s) -> (card (remove i s)) = ((card s) - 1)))).
Admitted.
Dp_hint remove_card.

(*Why logic*) Definition min_elt : iset -> Z.
Admitted.

(*Why axiom*) Lemma min_elt_def_1 :
  (forall (s:iset), ((card s) > 0 -> (in_ (min_elt s) s))).
Admitted.
Dp_hint min_elt_def_1.

(*Why axiom*) Lemma min_elt_def_2 :
  (forall (s:iset),
   ((card s) > 0 -> (forall (i:Z), ((in_ i s) -> (min_elt s) <= i)))).
Admitted.
Dp_hint min_elt_def_2.

(*Why logic*) Definition succ : iset -> iset.
Admitted.

(*Why axiom*) Lemma succ_def_1 :
  (forall (s:iset), (forall (i:Z), ((in_ i s) -> (in_ (i + 1) (succ s))))).
Admitted.
Dp_hint succ_def_1.

(*Why axiom*) Lemma succ_def_2 :
  (forall (s:iset),
   (forall (i:Z), ((in_ i (succ s)) -> i >= 1 /\ (in_ (i - 1) s)))).
Admitted.
Dp_hint succ_def_2.

(*Why logic*) Definition pred : iset -> iset.
Admitted.

(*Why axiom*) Lemma pred_def_1 :
  (forall (s:iset),
   (forall (i:Z), (i >= 0 -> ((in_ (i + 1) s) -> (in_ i (pred s)))))).
Admitted.
Dp_hint pred_def_1.

(*Why axiom*) Lemma pred_def_2 :
  (forall (s:iset), (forall (i:Z), ((in_ i (pred s)) -> (in_ (i + 1) s)))).
Admitted.
Dp_hint pred_def_2.

(*Why type*) Definition arr: Set ->Set.
Admitted.

(*Why logic*) Definition acc : forall (A1:Set), (arr A1) -> Z -> A1.
Admitted.
Implicit Arguments acc.

(*Why logic*) Definition upd :
  forall (A1:Set), (arr A1) -> Z -> A1 -> (arr A1).
Admitted.
Implicit Arguments upd.

(*Why axiom*) Lemma acc_upd_eq :
  forall (A1:Set),
  (forall (a:(arr A1)),
   (forall (i:Z), (forall (v:A1), (acc (upd a i v) i) = v))).
Admitted.
Implicit Arguments acc_upd_eq.
Dp_hint acc_upd_eq.

(*Why axiom*) Lemma acc_upd_neq :
  forall (A1:Set),
  (forall (a:(arr A1)),
   (forall (i:Z),
    (forall (j:Z),
     (forall (v:A1), (i <> j -> (acc (upd a i v) j) = (acc a j)))))).
Admitted.
Implicit Arguments acc_upd_neq.
Dp_hint acc_upd_neq.

(*Why predicate*) Definition eq_prefix (A178:Set) (t:(arr A178)) (u:(arr A178)) (i:Z)
  := (forall (k:Z), (0 <= k /\ k < i -> (acc t k) = (acc u k))).
Implicit Arguments eq_prefix.

(*Why predicate*) Definition partial_solution  (k:Z) (s:(arr Z))
  := (forall (i:Z),
      (0 <= i /\ i < k -> (0 <= (acc s i) /\ (acc s i) < N) /\
       (forall (j:Z),
        (0 <= j /\ j < i -> (acc s i) <> (acc s j) /\
         ((acc s i) - (acc s j)) <> (i - j) /\ ((acc s i) - (acc s j)) <>
         (j - i))))).

(*Why predicate*) Definition solution  (s:(arr Z)) := (partial_solution N s).

(*Why predicate*) Definition eq_sol  (t:(arr Z)) (u:(arr Z))
  := (eq_prefix t u N).
Implicit Arguments eq_sol.



(*Why axiom*) Lemma partial_solution_eq_prefix :
  (forall (t:(arr Z)),
   (forall (u:(arr Z)),
    (forall (k:Z),
     ((partial_solution k t) -> ((eq_prefix t u k) -> (partial_solution k u)))))).
Admitted.
Dp_hint partial_solution_eq_prefix.

Dp_debug.

(*Why predicate*) Definition lt_sol  (s1:(arr Z)) (s2:(arr Z))
  := (exists i:Z, (0 <= i /\ i < N) /\ (eq_prefix s1 s2 i) /\ (acc s1 i) <
      (acc s2 i)).

(*Why predicate*) Definition sorted  (s:(arr (arr Z))) (a:Z) (b:Z)
  := (forall (i:Z),
      (forall (j:Z),
       ((a <= i /\ i < j) /\ j < b -> (lt_sol (acc s i) (acc s j))))).

Proof.
ergo.
Save.

Proof.
ergo.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
Save.

Lemma lemma_count_25 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (i: Z),
  forall (HW_17: (in_ i (remove (min_elt e) a))),
  forall (j: Z),
  forall (HW_18: 0 <= j /\ j < k1),
  (* pre_a *) i <> (acc col1 j).
Proof.
intros; clear HW_16.
assert (h:j<k0 \/ j=k0). omega. destruct h.
clear HW_10.
subst col1. rewrite acc_upd_neq; try omega.
assert (in_ i a). ergo.
assert (k0=k). omega. subst k0.
assert (acc col0 j = acc col j). 
symmetry. intuition.
rewrite H1.   
clear HW_11; intuition.
clear H9 H10 H12; generalize (H8 i); clear H8; intuition.
ergo.
subst j col1. rewrite acc_upd_eq.
ergo.
Save.

Lemma lemma_count_26 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (i: Z),
  forall (HW_19: (0 <= i /\ i < N) /\
                 (forall (j:Z), (0 <= j /\ j < k1 -> i <> (acc col1 j)))),
  (* pre_a *) (in_ i (remove (min_elt e) a)).
Proof.
intros.
assert (i <> (min_elt e)). 
assert (acc col1 k0 = min_elt e). 
subst col1. rewrite acc_upd_eq; auto.
ergo.
assert (in_ i a).
clear HW_10; intuition.
clear H11 H13 H18.
generalize (H8 i); clear H8; intuition.
apply H13.
intros j Hj.
replace (acc col j) with (acc col0 j). 
replace (acc col0 j) with (acc col1 j).
ergo. ergo. ergo. ergo.
Save.

Lemma lemma_count_27 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (i: Z),
  forall (HW_20: 0 <= i),
  forall (HW_21: (in_ i (succ (add (min_elt e) b)))),
  (* pre_a *)
  (* pre_b *) (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) = (i + j - k1)).
Proof.
intros.
assert (h: i >= 1 /\ in_ (i-1) (add (min_elt e) b)). ergo. destruct h.
assert (h: i-1=min_elt e \/ in_ (i-1) b). ergo. destruct h.
ergo.
assert (h: exists j:Z, 0<=j<k /\ acc col j = (i-1)+j-k).
ergo.
destruct h as (j,(h1,h2)).
exists j; intuition.
simplify. (* ERGO fait timeout *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_count_28 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (i: Z),
  forall (HW_20: 0 <= i),
  forall (HW_22: (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                  (i + j - k1))),
  (* pre_a *) (* pre_b *) (in_ i (succ (add (min_elt e) b))).
Proof.
intros.
destruct HW_22 as (j,(h1,h2)).
replace i with ((i-1)+1). apply succ_def_1.
assert (h: j<k \/ j=k). omega. destruct h.
assert (in_ (i-1) b).
simplify. (* ERGO fait timeout *)
ergo.
assert (i-1=min_elt e).
subst col1. subst j.
assert (k0=k). omega. subst k0.
rewrite acc_upd_eq in h2.
omega.
ergo.
omega.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_count_30 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (i: Z),
  forall (HW_23: 0 <= i),
  forall (HW_25: (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                  (i + k1 - j))),
  (* pre_a *) (* pre_b *) (* pre_c *) (in_ i (pred (add (min_elt e) c))).
Proof.
intros.
destruct HW_25 as (j,(h1,h2)).
assert (acc col1 j >= 1). omega.
replace i with ((i+1)-1). apply pred_def_1.
omega.
assert (h: j<k \/ j=k). omega. destruct h.
assert (in_ (i+1) c).
simplify. (* ERGO fait timeout *)
ergo.
assert (i+1=min_elt e).
subst col1. subst j.
assert (k0=k). omega. subst k0.
rewrite acc_upd_eq in h2.
omega.
ergo.
omega.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_count_31 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  (* pre_a *) (* pre_b *) (* pre_c *) (partial_solution k1 col1).
Proof.
intros.
unfold partial_solution.
intros i hi. split.
simplify. (* ERGO fauit timeout *)
intros j hj.
assert (k0=k). omega. subst k0.
assert (h: i<k \/ i=k). omega. destruct h. 
subst col1. rewrite acc_upd_neq.
rewrite acc_upd_neq.
decompose [and] HW_11. 
clear HW_1 HW_10 HW_11 H8.
unfold partial_solution in H4.
generalize (H4 i); ergo.
omega.
omega.
subst i col1; rewrite acc_upd_eq.
rewrite acc_upd_neq.
assert (in_ (min_elt e) a). ergo.
assert (~(in_ (min_elt e) b)). simplify. (*ERGO*)
assert (~(in_ (min_elt e) c)). simplify. (*ERGO*)
2: omega.
replace (acc col0 j) with (acc col j). 2:ergo.
clear HW_11 HW_10.
decompose [and] HW_1; clear HW_1.
destruct (H5 (min_elt e)); clear H5.
destruct (H6 (min_elt e)); clear H6.
ergo.
destruct (H7 (min_elt e)); clear H7.
intuition.
ergo.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_count_39 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (HW_26: 0 <= k1 /\ (k1 + (card (remove (min_elt e) a))) = N /\ 0 <=
                 s0 /\
                 (* pre_a *)
                 ((forall (i:Z),
                   ((in_ i (remove (min_elt e) a)) <-> (0 <= i /\ i < N) /\
                    (forall (j:Z), (0 <= j /\ j < k1 -> i <> (acc col1 j))))) /\
                 (* pre_b *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (succ (add (min_elt e) b))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + j - k1))))) /\
                 (* pre_c *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (pred (add (min_elt e) c))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + k1 - j))))) /\
                 (partial_solution k1 col1))))),
  forall (result: Z),
  forall (col2: ((arr) Z)),
  forall (k2: Z),
  forall (s1: Z),
  forall (sol1: ((arr) ((arr) Z))),
  forall (HW_27: result = (s1 - s0) /\ result >= 0 /\ k2 = k1 /\
                 (eq_prefix col1 col2 k2) /\ (eq_prefix sol0 sol1 s0) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\ (eq_prefix col2 t k2) <->
                   (exists i:Z, (s0 <= i /\ i < s1) /\
                    (eq_sol t (acc sol1 i)))))),
  forall (f0: Z),
  forall (HW_28: f0 = (f + result)),
  forall (k3: Z),
  forall (HW_29: k3 = (k2 - 1)),
  forall (t: ((arr) Z)),
  forall (HW_30: (solution t) /\
                 (exists di:Z, (in_ di (diff (diff (diff a b) c) e0)) /\
                  (eq_prefix (upd col2 k3 di) t (k3 + 1)))),
  (exists i:Z, (s <= i /\ i < s1) /\ (eq_sol t (acc sol1 i))).
Proof.
intros.
destruct HW_30 as (h,(di,(h1,h2))).
assert (hdi: di=min_elt e \/ in_ di (diff (diff (diff a b) c) e)).
simplify. (*ERGO*)
destruct hdi.
subst di.
decompose [and] HW_27.
destruct (H5 t).
destruct H4.
split; auto.
simplify. (*ERGO*)
exists x; intuition.
assert (hs: 0<=s). omega.
clear HW_1 HW_10 HW_26.
intuition.
generalize (H14 t); clear H14. intuition.
clear H15. destruct H14.
exists di; intuition.
subst k3 k2 k1 k0.
assert 
  (eq_prefix_trans: forall (a b c:arr Z) k, eq_prefix a b k ->
      eq_prefix b c k -> eq_prefix a c k).
simplify. (*ERGO*)
apply eq_prefix_trans with (upd col1 k di).
simplify. (*ERGO*)
simplify. (*ERGO*)
exists x; intuition.
red in H9.
rewrite <- H9.
ergo.
omega.
Save.

Lemma lemma_count_41 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_12: (card e) > 0),
  forall (e0: iset),
  forall (HW_13: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_14: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_15: k1 = (k0 + 1)),
  forall (HW_16: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (HW_26: 0 <= k1 /\ (k1 + (card (remove (min_elt e) a))) = N /\
                 (* pre_a *)
                 ((forall (i:Z),
                   ((in_ i (remove (min_elt e) a)) <-> (0 <= i /\ i < N) /\
                    (forall (j:Z), (0 <= j /\ j < k1 -> i <> (acc col1 j))))) /\
                 (* pre_b *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (succ (add (min_elt e) b))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + j - k1))))) /\
                 (* pre_c *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (pred (add (min_elt e) c))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + k1 - j))))) /\
                 (partial_solution k1 col1))))),
  forall (result: Z),
  forall (col2: ((arr) Z)),
  forall (k2: Z),
  forall (s1: Z),
  forall (sol1: ((arr) ((arr) Z))),
  forall (HW_27: result = (s1 - s0) /\ result >= 0 /\ k2 = k1 /\
                 (eq_prefix col1 col2 k2) /\ (eq_prefix sol0 sol1 s0) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\ (eq_prefix col2 t k2) <->
                   (exists i:Z, (s0 <= i /\ i < s1) /\
                    (eq_sol t (acc sol1 i)))))),
  forall (f0: Z),
  forall (HW_28: f0 = (f + result)),
  forall (k3: Z),
  forall (HW_29: k3 = (k2 - 1)),
  forall (t: ((arr) Z)),
  forall (HW_31: (exists i:Z, (s <= i /\ i < s1) /\ (eq_sol t (acc sol1 i)))),
  (exists di:Z, (in_ di (diff (diff (diff a b) c) e0)) /\
   (eq_prefix (upd col2 k3 di) t (k3 + 1))).
Proof.
intuition.
destruct HW_31 as (i,(hi,hsoli)).
assert (s <= i < s0 \/ s0 <= i < s1). omega. intuition.
clear H22 H24 H25 H33.
generalize (H21 t); intuition.
clear H22. destruct H25.
exists i; intuition.
unfold eq_prefix in H31.
rewrite H31; intuition.
admit. admit. admit.
Qed.

Lemma lemma_count_39_bis : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_12: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\
                 (forall (i:Z),
                  (forall (j:Z),
                   ((in_ i (diff (diff (diff a b) c) (diff (diff a b) c))) ->
                    ((in_ j (diff (diff a b) c)) -> i < j)))) /\
                 (partial_solution k col) /\ (eq_prefix col col k) /\
                 (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i))))) /\
                 (sorted sol s s)),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_13: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\
                 (forall (i:Z),
                  (forall (j:Z),
                   ((in_ i (diff (diff (diff a b) c) e)) ->
                    ((in_ j e) -> i < j)))) /\
                 (partial_solution k0 col0) /\ (eq_prefix col col0 k) /\
                 (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i))))) /\
                 (sorted sol0 s s0)),
  forall (HW_14: (card e) > 0),
  forall (e0: iset),
  forall (HW_15: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_16: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_17: k1 = (k0 + 1)),
  forall (HW_18: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (HW_28: 0 <= k1 /\ (k1 + (card (remove (min_elt e) a))) = N /\ 0 <=
                 s0 /\
                 (* pre_a *)
                 ((forall (i:Z),
                   ((in_ i (remove (min_elt e) a)) <-> (0 <= i /\ i < N) /\
                    (forall (j:Z), (0 <= j /\ j < k1 -> i <> (acc col1 j))))) /\
                 (* pre_b *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (succ (add (min_elt e) b))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + j - k1))))) /\
                 (* pre_c *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (pred (add (min_elt e) c))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + k1 - j))))) /\
                 (partial_solution k1 col1))))),
  forall (result: Z),
  forall (col2: ((arr) Z)),
  forall (k2: Z),
  forall (s1: Z),
  forall (sol1: ((arr) ((arr) Z))),
  forall (HW_29: result = (s1 - s0) /\ result >= 0 /\ k2 = k1 /\
                 (eq_prefix col1 col2 k2) /\ (eq_prefix sol0 sol1 s0) /\
                 (sorted sol1 s0 s1) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\ (eq_prefix col2 t k2) <->
                   (exists i:Z, (s0 <= i /\ i < s1) /\
                    (eq_sol t (acc sol1 i)))))),
  forall (f0: Z),
  forall (HW_30: f0 = (f + result)),
  forall (k3: Z),
  forall (HW_31: k3 = (k2 - 1)),
  forall (i: Z),
  forall (j: Z),
  forall (HW_32: (in_ i (diff (diff (diff a b) c) e0))),
  forall (HW_33: (in_ j e0)),
  i < j.
Proof.
intuition.
clear H5 H14 H24 H29 H30 H31 H40.
assert (hje: in_ j e). ergo.
assert (hi1: in_ i (diff (diff a b) c)). ergo.
assert (hi2: ~(in_ i e0)). ergo.
assert (hi: i=min_elt e \/ in_ i (diff (diff (diff a b) c) e)); ergo.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_count_46 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\ 0 <= s /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_12: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\
                 (forall (i:Z),
                  (forall (j:Z),
                   ((in_ i (diff (diff (diff a b) c) (diff (diff a b) c))) ->
                    ((in_ j (diff (diff a b) c)) -> i < j)))) /\
                 (partial_solution k col) /\ (eq_prefix col col k) /\
                 (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i))))) /\
                 (sorted sol s s)),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_13: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\
                 (forall (i:Z),
                  (forall (j:Z),
                   ((in_ i (diff (diff (diff a b) c) e)) ->
                    ((in_ j e) -> i < j)))) /\
                 (partial_solution k0 col0) /\ (eq_prefix col col0 k) /\
                 (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i))))) /\
                 (sorted sol0 s s0)),
  forall (HW_14: (card e) > 0),
  forall (e0: iset),
  forall (HW_15: e0 = (remove (min_elt e) e)),
  forall (col1: ((arr) Z)),
  forall (HW_16: col1 = (upd col0 k0 (min_elt e))),
  forall (k1: Z),
  forall (HW_17: k1 = (k0 + 1)),
  forall (HW_18: (Zwf 0 (card (remove (min_elt e) a)) (card a))),
  forall (HW_28: 0 <= k1 /\ (k1 + (card (remove (min_elt e) a))) = N /\ 0 <=
                 s0 /\
                 (* pre_a *)
                 ((forall (i:Z),
                   ((in_ i (remove (min_elt e) a)) <-> (0 <= i /\ i < N) /\
                    (forall (j:Z), (0 <= j /\ j < k1 -> i <> (acc col1 j))))) /\
                 (* pre_b *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (succ (add (min_elt e) b))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + j - k1))))) /\
                 (* pre_c *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i (pred (add (min_elt e) c))) <->
                     (exists j:Z, (0 <= j /\ j < k1) /\ (acc col1 j) =
                      (i + k1 - j))))) /\
                 (partial_solution k1 col1))))),
  forall (result: Z),
  forall (col2: ((arr) Z)),
  forall (k2: Z),
  forall (s1: Z),
  forall (sol1: ((arr) ((arr) Z))),
  forall (HW_29: result = (s1 - s0) /\ result >= 0 /\ k2 = k1 /\
                 (eq_prefix col1 col2 k2) /\ (eq_prefix sol0 sol1 s0) /\
                 (sorted sol1 s0 s1) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\ (eq_prefix col2 t k2) <->
                   (exists i:Z, (s0 <= i /\ i < s1) /\
                    (eq_sol t (acc sol1 i)))))),
  forall (f0: Z),
  forall (HW_30: f0 = (f + result)),
  forall (k3: Z),
  forall (HW_31: k3 = (k2 - 1)),
  (sorted sol1 s s1).
Proof.
intuition. clear H29 H30 H31.
red; intros.
assert (h: s0 <= i \/ j<s0 \/ (i<s0 /\ s0 <= j)). omega.
destruct h.
red in H38. ergo.
destruct H30.
red in H26. 
assert (acc sol0 i = acc sol1 i). ergo.
assert (acc sol0 j = acc sol1 j). ergo.
ergo.
red.
assert (hj: solution (acc sol1 j) /\ eq_prefix col2 (acc sol1 j) k2).
generalize (H40 (acc sol1 j)); clear H40. 
intros (_,h2). apply h2.
exists j; intuition.
red; ergo.
destruct hj.
assert (hi: 
   (solution (acc sol1 i)) /\
   (exists di : Z,
          in_ di (diff (diff (diff a b) c) e) /\
          eq_prefix (upd col0 k0 di) (acc sol1 i) (k0 + 1))).
generalize (H24 (acc sol1 i)); clear H24. 
intros (_,h2). apply h2.
exists i; intuition.
assert (acc sol0 i = acc sol1 i). simplify.
simplify.
destruct hi.
exists k0; intuition.
ergo.
simplify.
destruct H42 as (di,(hdi1,hdi2)).
replace (acc (acc sol1 i) k0) with di. 2: simplify.
replace (acc (acc sol1 j) k0) with (min_elt e); simplify.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_count_49 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_32: (card e) <= 0),
  forall (t: ((arr) Z)),
  forall (HW_33: (solution t) /\ (eq_prefix col0 t k0)),
  (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i))).
Proof.
intros.
clear HW_10; intuition.
generalize (H15 t); clear H15; intuition.
clear H16.
apply H15; clear H15.
exists (acc t k0).
assert (k0N: k0<N).
generalize (card_nonneg a); intuition.
subst k; split.
assert (e=empty).
assert (card e=0).
generalize (card_nonneg e); intuition.
generalize (empty_card e); intuition.
subst e. generalize (diff_def (diff (diff a b) c) empty (acc t k0)).
intuition.
apply H8; clear H8 H14.
generalize (diff_def (diff a b) c (acc t k0)).
intuition.
apply H8; clear H8 H14.
generalize (diff_def a b (acc t k0)).
intuition.
apply H8; clear H8 H14.
(* acc t k0 in a *)
clear H7 H9. unfold solution in H3.
unfold partial_solution in H3.
generalize (H2 (acc t k0)); clear H2; intuition.
apply H8.
generalize (H3 k0); intuition.
generalize (H3 k0); intuition.
unfold eq_prefix in H4, H11.
intros j Hj.
rewrite H11; [idtac|intuition].
rewrite H4; [idtac|intuition].
generalize (H3 k0); intuition.
generalize (H17 j); intuition.
(* acc t k0 not in b *)
clear H2 H9. unfold solution in H3.
unfold partial_solution in H3.
generalize (H3 k0); clear H3; intuition.
generalize (H7 (acc t k0)); clear H7; intuition.
destruct H7.
generalize (H9 x); intuition.
unfold eq_prefix in H4, H11.
rewrite H11 in H17; [idtac|intuition].
rewrite H4 in H17; [idtac|intuition].
intuition.
(* acc t k0 not in c *)
clear H2 H7. unfold solution in H3.
unfold partial_solution in H3.
generalize (H3 k0); clear H3; intuition.
generalize (H9 (acc t k0)); clear H9; intuition.
destruct H9.
generalize (H8 x); intuition.
unfold eq_prefix in H4, H11.
rewrite H11 in H17; [idtac|intuition].
rewrite H4 in H17; [idtac|intuition].
intuition.
(* acc t k0 not in empty *)
apply empty_def.
(* eq_prefix *)
clear H2 H7 H9.
unfold eq_prefix; intros.
assert (k=k0 \/ k<k0). omega. intuition.
subst k; rewrite acc_upd_eq; trivial.
rewrite acc_upd_neq; try omega.
unfold eq_prefix in H4.
rewrite H4; intuition.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_count_51 : 
  forall (a: iset),
  forall (b: iset),
  forall (c: iset),
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: 0 <= k /\ (k + (card a)) = N /\
                (* pre_a *)
                ((forall (i:Z),
                  ((in_ i a) <-> (0 <= i /\ i < N) /\
                   (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                (* pre_b *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i b) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + j - k))))) /\
                (* pre_c *)
                ((forall (i:Z),
                  (0 <= i ->
                   ((in_ i c) <->
                    (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                     (i + k - j))))) /\
                (partial_solution k col))))),
  forall (HW_7: (card a) <> 0),
  forall (HW_10: (included (diff (diff a b) c) (diff (diff a b) c)) /\ 0 =
                 (s - s) /\ 0 >= 0 /\ k = k /\ (partial_solution k col) /\
                 (eq_prefix col col k) /\ (eq_prefix sol sol s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z,
                    (in_ di (diff (diff (diff a b) c) (diff (diff a b) c))) /\
                    (eq_prefix (upd col k di) t (k + 1))) <->
                   (exists i:Z, (s <= i /\ i < s) /\ (eq_sol t (acc sol i)))))),
  forall (col0: ((arr) Z)),
  forall (e: iset),
  forall (f: Z),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_11: (included e (diff (diff a b) c)) /\ f = (s0 - s) /\ f >=
                 0 /\ k0 = k /\ (partial_solution k0 col0) /\
                 (eq_prefix col col0 k) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\
                   (exists di:Z, (in_ di (diff (diff (diff a b) c) e)) /\
                    (eq_prefix (upd col0 k0 di) t (k0 + 1))) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (HW_32: (card e) <= 0),
  forall (t: ((arr) Z)),
  forall (HW_34: (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))),
  (eq_prefix col0 t k0).
Proof.
intuition.
generalize (H21 t); clear H21; intuition.
destruct H23; intuition.
clear H2 H5 H7 H13.
unfold eq_prefix; unfold eq_prefix in H24.
intros; rewrite <- H24.
rewrite acc_upd_neq.
trivial.
omega.
omega.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

(*Why logic*) Definition below_N : iset.
Admitted.

(*Why axiom*) Lemma below_N_def :
  (forall (i:Z), ((in_ i below_N) <-> 0 <= i /\ i < N)).
Admitted.

(*Why axiom*) Lemma below_N_card : (card below_N) = N.
Admitted.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Lemma lemma_queens_13:
  forall (col: ((arr) Z)),
  forall (k: Z),
  forall (s: Z),
  forall (sol: ((arr) ((arr) Z))),
  forall (HW_1: s = 0 /\ k = 0),
  forall (HW_11: 0 <= k /\ (k + (card below_N)) = N /\
                 (* pre_a *)
                 ((forall (i:Z),
                   ((in_ i below_N) <-> (0 <= i /\ i < N) /\
                    (forall (j:Z), (0 <= j /\ j < k -> i <> (acc col j))))) /\
                 (* pre_b *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i empty) <->
                     (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                      (i + j - k))))) /\
                 (* pre_c *)
                 ((forall (i:Z),
                   (0 <= i ->
                    ((in_ i empty) <->
                     (exists j:Z, (0 <= j /\ j < k) /\ (acc col j) =
                      (i + k - j))))) /\
                 (partial_solution k col))))),
  forall (result: Z),
  forall (col0: ((arr) Z)),
  forall (k0: Z),
  forall (s0: Z),
  forall (sol0: ((arr) ((arr) Z))),
  forall (HW_12: result = (s0 - s) /\ result >= 0 /\ k0 = k /\
                 (eq_prefix col col0 k0) /\ (eq_prefix sol sol0 s) /\
                 (forall (t:((arr) Z)),
                  ((solution t) /\ (eq_prefix col0 t k0) <->
                   (exists i:Z, (s <= i /\ i < s0) /\ (eq_sol t (acc sol0 i)))))),
  forall (t: ((arr) Z)),
  forall (HW_13: (solution t)),
  (exists i:Z, (0 <= i /\ i < s0) /\ (eq_sol t (acc sol0 i))).
Proof.
intuition.
assert (eq_prefix col0 t 0).
unfold eq_prefix.
admit.
admit.
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

Proof.
admit.
(* FILL PROOF HERE *)
Save.

