(**************************************************************************)
(*                                                                        *)
(*  The Why platform for program certification                            *)
(*  Copyright (C) 2002-2008                                               *)
(*    Romain BARDOU                                                       *)
(*    Jean-Franois COUCHOT                                               *)
(*    Mehdi DOGGUY                                                        *)
(*    Jean-Christophe FILLITRE                                           *)
(*    Thierry HUBERT                                                      *)
(*    Claude MARCH                                                       *)
(*    Yannick MOY                                                         *)
(*    Christine PAULIN                                                    *)
(*    Yann RGIS-GIANAS                                                   *)
(*    Nicolas ROUSSET                                                     *)
(*    Xavier URBAIN                                                       *)
(*                                                                        *)
(*  This software is free software; you can redistribute it and/or        *)
(*  modify it under the terms of the GNU Library General Public           *)
(*  License version 2, with the special exception on linking              *)
(*  described in file LICENSE.                                            *)
(*                                                                        *)
(*  This software is distributed in the hope that it will be useful,      *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *)
(*                                                                        *)
(**************************************************************************)

(*i $Id: monomorph.mli,v 1.14 2008-11-05 14:03:17 filliatr Exp $ i*)

(* make a monorphic output for provers not supporting polymorphism
   (e.g. PVS or CVC Lite) *)

(* input... *)

val push_decl : Logic_decl.t -> unit

val add_external : Ident.t -> unit

(* ...and output *)

val iter : (Logic_decl.t -> unit) -> unit

val reset : unit -> unit

(* [symbol id i] prints the instance [i] of symbol [id] using the same 
   conventions as in the monomorphization process *)

val symbol : Ident.t * Logic.instance -> string
