(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require list.Append.
Require list.Reverse.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive tree :=
  | Leaf : tree
  | Node : tree -> tree -> tree.
Axiom tree_WhyType : WhyType tree.
Existing Instance tree_WhyType.

(* Why3 assumption *)
Fixpoint depths (d:Z) (t:tree) {struct t}: (list Z) :=
  match t with
  | Leaf => (Init.Datatypes.cons d Init.Datatypes.nil)
  | (Node l r) => (Init.Datatypes.app (depths (d + 1%Z)%Z
      l) (depths (d + 1%Z)%Z r))
  end.

Axiom depths_head : forall (t:tree) (d:Z), match (depths d
  t) with
  | (Init.Datatypes.cons x _) => (d <= x)%Z
  | Init.Datatypes.nil => False
  end.

Axiom depths_unique : forall (t1:tree) (t2:tree) (d:Z) (s1:(list Z))
  (s2:(list Z)), ((Init.Datatypes.app (depths d
  t1) s1) = (Init.Datatypes.app (depths d t2) s2)) -> ((t1 = t2) /\
  (s1 = s2)).

Axiom depths_prefix : forall (t:tree) (d1:Z) (d2:Z) (s1:(list Z))
  (s2:(list Z)), ((Init.Datatypes.app (depths d1
  t) s1) = (Init.Datatypes.app (depths d2 t) s2)) -> (d1 = d2).

Axiom depths_prefix_simple : forall (t:tree) (d1:Z) (d2:Z), ((depths d1
  t) = (depths d2 t)) -> (d1 = d2).

Axiom depths_subtree : forall (t1:tree) (t2:tree) (d1:Z) (d2:Z)
  (s1:(list Z)), ((Init.Datatypes.app (depths d1 t1) s1) = (depths d2 t2)) ->
  (d2 <= d1)%Z.

Axiom depths_unique2 : forall (t1:tree) (t2:tree) (d1:Z) (d2:Z), ((depths d1
  t1) = (depths d2 t2)) -> ((d1 = d2) /\ (t1 = t2)).

(* Why3 assumption *)
Fixpoint forest_depths (f:(list (Z* tree)%type)) {struct f}: (list Z) :=
  match f with
  | Init.Datatypes.nil => Init.Datatypes.nil
  | (Init.Datatypes.cons (d, t) r) => (Init.Datatypes.app (depths d
      t) (forest_depths r))
  end.

Axiom forest_depths_append : forall (f1:(list (Z* tree)%type)) (f2:(list (Z*
  tree)%type)),
  ((forest_depths (Init.Datatypes.app f1 f2)) = (Init.Datatypes.app (forest_depths f1) (forest_depths f2))).

(* Why3 assumption *)
Fixpoint greedy (d:Z) (d1:Z) (t1:tree) {struct t1}: Prop := (~ (d = d1)) /\
  match t1 with
  | Leaf => True
  | (Node l1 _) => (greedy d (d1 + 1%Z)%Z l1)
  end.

(* Why3 assumption *)
Inductive g: (list (Z* tree)%type) -> Prop :=
  | Gnil : (g Init.Datatypes.nil)
  | Gone : forall (d:Z) (t:tree), (g (Init.Datatypes.cons (d,
      t) Init.Datatypes.nil))
  | Gtwo : forall (d1:Z) (d2:Z) (t1:tree) (t2:tree) (l:(list (Z*
      tree)%type)), (greedy d1 d2 t2) -> ((g (Init.Datatypes.cons (d1,
      t1) l)) -> (g (Init.Datatypes.cons (d2, t2) (Init.Datatypes.cons (d1,
      t1) l)))).

Axiom g_append : forall (l1:(list (Z* tree)%type)) (l2:(list (Z*
  tree)%type)), (g (Init.Datatypes.app l1 l2)) -> (g l1).

Axiom right_nil : forall (l:(list (Z* tree)%type)),
  (2%Z <= (list.Length.length l))%Z -> ((g l) -> forall (t:tree) (d:Z),
  ~ ((forest_depths (Lists.List.rev l)) = (depths d t))).

Require Import Why3. 
Ltac z := why3 "Z3,4.4.0," timelimit 5; admit.

(*
Lemma key_lemma:
  forall t t1 t2 s d2 d d1, (d < d1)%Z -> 
  match t2 with Leaf => True | Node left2 _ => g (Cons (d1, t1) (Cons ((d2+1)%Z, left2) Nil)) end ->
  infix_plpl (depths d1 t1) (depths d2 t2) = infix_plpl (depths d t) s ->
  d = (d1-1)%Z /\ d2 = d1.
induction t; simpl.
(* t = Leaf *)
intros.
assert (d >= d1)%Z.
  clear H.
  generalize H1; clear H1.
  generalize (depths d2 t2).
  generalize d1.
  induction t1; simpl.
  z.
(*

  z.
omega.
(* t = Node t1 t2 *)
rename t1 into left, t2 into right.
intros t1 t2 s d2 d d1 ineq.
rewrite <- Append_assoc.
intro eq.
assert (case: (d+1 < d1 \/ d=d1-1)%Z) by omega. destruct case.
(* d+1 < d1, by iH *)
generalize (IHt1 t1 t2 (infix_plpl (depths (d + 1) right) s) d2 (d+1) d1 H eq)%Z.
intuition.


subst.
replace (infix_plpl (depths d2 t1) (depths d2 t2))
  with (depths (d2-1) (Node t1 t2))%Z in eq.
rewrite H0 in eq.
assert (Node t1 t2 = left) by z.
rewrite H0 in eq.
replace (depths (d2 - 1) left) with (infix_plpl (depths (d2 - 1) left) Nil) in eq by z.
z.
simpl.
replace  (d2 - 1 + 1)%Z with d2; z.
(* d+1 = d1 *)
intuition.
replace (d+1)%Z with d1 in eq by z.
assert (t1 = left) by z.
subst.
assert (depths d2 t2 = infix_plpl (depths d1 right) s) by z.
assert (d2 <= d1)%Z by z.
assert (case: (d2 < d1 \/ d2=d1)%Z) by omega. destruct case. 2: auto.

*)
Admitted.
*)

(*
Lemma key_lemma_greedy:
  forall l d t t1 t2 d1 d2, d1 <> d2 ->
  g d t (infix_plpl l (Cons (d1, t1) Nil)) ->
  match t2 with
  | (Node l2 _) => g (infix_plpl l (Cons (d1, t1) (Cons ((d2 + 1%Z)%Z, l2))))
  | Leaf => True end ->
  greedy d t (infix_plpl l (Cons (d1, t1) (Cons (d2, t2) Nil))).
induction l; simpl.
unfold greedy; simpl.
intros d t t1 t2 d1 d2 ineq.
do 2 rewrite Append_l_nil.
(* l = Nil *)
admit.
(* l = Cons _ _ *)
unfold greedy; simpl.
intros.
destruct a.
z.
(*
z.
unfold greedy; simpl.
intros. z.
Qed.
*)
Admitted.
*)

(* Why3 goal *)
Theorem main_lemma : forall (l:(list (Z* tree)%type)) (d1:Z) (d2:Z) (t1:tree)
  (t2:tree), (~ (d1 = d2)) -> ((g (Init.Datatypes.cons (d1, t1) l)) ->
  (match t2 with
  | (Node l2 _) => (greedy d1 (d2 + 1%Z)%Z l2)
  | Leaf => True
  end -> (g (Init.Datatypes.cons (d2, t2) (Init.Datatypes.cons (d1,
  t1) l))))).
(* Why3 intros l d1 d2 t1 t2 h1 h2 h3. *)
intros; apply Gtwo.
destruct t2; z.
assumption.
(**
simpl.
intro l; generalize (reverse l). clear l.
induction l; simpl.
(* length = 2 *)
intros d1 d2 t1 t2 ineq _ ht2.
apply Gtwo.
red; intros.
simpl.
intros eq.
z.
z.
(* length > 2 *)
intros.
assert (g ((infix_plpl l (Cons (d1,t1) Nil)))).
  inversion H0; auto.
  z.
destruct a.
inversion H0.
z.
apply Gtwo.
(* greedy *)
replace 
      (infix_plpl (infix_plpl l (Cons (d1, t1) Nil)) (Cons (d2, t2) Nil))
 with (infix_plpl l (Cons (d1, t1) (Cons (d2, t2) Nil))) by z.
apply key_lemma_greedy; auto.
(* g *)
apply IHl; auto.
destruct t2; auto.
inversion H1; z.
**)
Admitted.

