(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require map.Map.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require list.Append.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(@ref a a_WT)): a :=
  match v with
  | (mk_ref x) => x
  end.

Axiom loc : Type.
Parameter loc_WhyType : WhyType loc.
Existing Instance loc_WhyType.

Parameter null: loc.

(* Why3 assumption *)
Inductive node :=
  | mk_node : loc -> loc -> Z -> node.
Axiom node_WhyType : WhyType node.
Existing Instance node_WhyType.

(* Why3 assumption *)
Definition data (v:node): Z := match v with
  | (mk_node x x1 x2) => x2
  end.

(* Why3 assumption *)
Definition right1 (v:node): loc := match v with
  | (mk_node x x1 x2) => x1
  end.

(* Why3 assumption *)
Definition left1 (v:node): loc := match v with
  | (mk_node x x1 x2) => x
  end.

(* Why3 assumption *)
Definition memory := (@map.Map.map loc loc_WhyType node node_WhyType).

(* Why3 assumption *)
Inductive tree
  (a:Type) {a_WT:WhyType a} :=
  | Empty : tree a
  | Node : (@tree a a_WT) -> a -> (@tree a a_WT) -> tree a.
Axiom tree_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (tree a).
Existing Instance tree_WhyType.
Implicit Arguments Empty [[a] [a_WT]].
Implicit Arguments Node [[a] [a_WT]].

(* Why3 assumption *)
Fixpoint inorder {a:Type} {a_WT:WhyType a} (t:(@tree
  a a_WT)) {struct t}: (list a) :=
  match t with
  | Empty => nil
  | (Node l x r) => (List.app (inorder l) (cons x (inorder r)))
  end.

(* Why3 assumption *)
Inductive distinct {a:Type} {a_WT:WhyType a} : (list a) -> Prop :=
  | distinct_zero : ((@distinct _ _) nil)
  | distinct_one : forall (x:a), ((@distinct _ _) (cons x nil))
  | distinct_many : forall (x:a) (l:(list a)), (~ (list.Mem.mem x l)) ->
      (((@distinct _ _) l) -> ((@distinct _ _) (cons x l))).

Axiom distinct_append : forall {a:Type} {a_WT:WhyType a},
  forall (l1:(list a)) (l2:(list a)), (distinct l1) -> ((distinct l2) ->
  ((forall (x:a), (list.Mem.mem x l1) -> ~ (list.Mem.mem x l2)) -> (distinct
  (List.app l1 l2)))).

(* Why3 assumption *)
Inductive istree : (@map.Map.map loc loc_WhyType node node_WhyType) -> loc ->
  (@tree loc loc_WhyType) -> Prop :=
  | leaf : forall (m:(@map.Map.map loc loc_WhyType node node_WhyType)),
      (istree m null (Empty :(@tree loc loc_WhyType)))
  | node1 : forall (m:(@map.Map.map loc loc_WhyType node node_WhyType))
      (p:loc) (l:(@tree loc loc_WhyType)) (r:(@tree loc loc_WhyType)),
      (~ (p = null)) -> ((istree m (left1 (map.Map.get m p)) l) -> ((istree m
      (right1 (map.Map.get m p)) r) -> (istree m p (Node l p r)))).

(* Why3 assumption *)
Inductive zipper
  (a:Type) {a_WT:WhyType a} :=
  | Top : zipper a
  | Left : (@zipper a a_WT) -> a -> (@tree a a_WT) -> zipper a.
Axiom zipper_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (zipper a).
Existing Instance zipper_WhyType.
Implicit Arguments Top [[a] [a_WT]].
Implicit Arguments Left [[a] [a_WT]].

(* Why3 assumption *)
Fixpoint zip {a:Type} {a_WT:WhyType a} (t:(@tree a a_WT)) (z:(@zipper
  a a_WT)) {struct z}: (@tree a a_WT) :=
  match z with
  | Top => t
  | (Left z1 x r) => (zip (Node t x r) z1)
  end.

Axiom inorder_zip : forall {a:Type} {a_WT:WhyType a}, forall (z:(@zipper
  a a_WT)) (x:a) (l:(@tree a a_WT)) (r:(@tree a a_WT)),
  ((inorder (zip (Node l x r)
  z)) = (List.app (inorder l) (cons x (inorder (zip r z))))).

Axiom main_lemma : forall (m:(@map.Map.map loc loc_WhyType
  node node_WhyType)) (t:loc) (pp:loc) (p:loc) (ppr:(@tree loc loc_WhyType))
  (pr:(@tree loc loc_WhyType)) (z:(@zipper loc loc_WhyType)), let it :=
  (zip (Node (Node (Empty :(@tree loc loc_WhyType)) p pr) pp ppr) z) in
  ((istree m t it) -> ((distinct (inorder it)) -> (istree (map.Map.set m pp
  (mk_node (right1 (map.Map.get m p)) (right1 (map.Map.get m pp))
  (data (map.Map.get m pp)))) t (zip (Node pr pp ppr) z)))).

Require Import Why3. Ltac ae := why3 "alt-ergo" timelimit 3.

(* Why3 goal *)
Theorem WP_parameter_search_tree_delete_min : forall (t:loc) (it:(@tree
  loc loc_WhyType)), forall (mem:(@map.Map.map loc loc_WhyType
  node node_WhyType)), ((~ (t = null)) /\ ((istree mem t it) /\ (distinct
  (inorder it)))) -> ((~ (t = null)) -> ((~ ((left1 (map.Map.get mem
  t)) = null)) -> ((~ ((left1 (map.Map.get mem t)) = null)) ->
  ((~ (it = (Empty :(@tree loc loc_WhyType)))) -> forall (o:(@tree
  loc loc_WhyType)),
  match it with
  | Empty => False
  | (Node _ _ r) => (o = r)
  end -> ((~ (it = (Empty :(@tree loc loc_WhyType)))) -> forall (o1:(@tree
  loc loc_WhyType)),
  match it with
  | Empty => False
  | (Node l _ _) => (o1 = l)
  end -> forall (subtree:(@tree loc loc_WhyType)) (ppr:(@tree
  loc loc_WhyType)) (zipper1:(@zipper loc loc_WhyType)) (tt:loc) (pp:loc)
  (p:loc), (((~ (pp = null)) /\ ((left1 (map.Map.get mem pp)) = p)) /\
  (((~ (p = null)) /\ ((left1 (map.Map.get mem p)) = tt)) /\ let pt :=
  (Node subtree pp ppr) in ((istree mem pp pt) /\ ((zip pt
  zipper1) = it)))) -> ((tt = null) -> ((istree mem p subtree) ->
  ((~ (pp = p)) -> ((~ (p = null)) -> ((~ (p = null)) -> forall (tt1:loc),
  (tt1 = (right1 (map.Map.get mem p))) -> let q_ := (map.Map.get mem pp) in
  forall (mem1:(@map.Map.map loc loc_WhyType node node_WhyType)),
  (mem1 = (map.Map.set mem pp (mk_node tt1 (right1 q_) (data q_)))) ->
  ((~ (subtree = (Empty :(@tree loc loc_WhyType)))) -> forall (pl:(@tree
  loc loc_WhyType)),
  match subtree with
  | Empty => False
  | (Node l _ _) => (pl = l)
  end -> ((pl = (Empty :(@tree loc loc_WhyType))) ->
  ((~ (subtree = (Empty :(@tree loc loc_WhyType)))) -> forall (o2:(@tree
  loc loc_WhyType)),
  match subtree with
  | Empty => False
  | (Node _ _ r) => (o2 = r)
  end -> forall (ot:(@tree loc loc_WhyType)), (ot = (zip o2 (Left zipper1 pp
  ppr))) ->
  match (inorder it) with
  | nil => True
  | (cons p1 l) => ((inorder ot) = l)
  end))))))))))))).
intros t it mem (h1,(h2,h3)) h4 h5 h6 h7 o h8 h9 o1 h10 subtree ppr
        zipper1 tt pp p ((h11,h12),((h13,h14),h15)) h16 h17 h18 h19 h20 tt1
        h21 q_ mem1 h22 h23 pl h24 h25 h26 o2 h27 ot h28.
destruct subtree; auto.
intuition.
intros.
subst subtree1; simpl in h15.
intuition.
rewrite <- H0.
subst pl; simpl.
rewrite inorder_zip.
simpl.
ae.
Qed.

