//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDNWDEV_H
#define WSDNWDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>

class WSDnwDev :public WSDdev{

  protected: 
    static short _back_x;
    static short _back_y;
    static short _copy_pixmap_x;
    static short _copy_pixmap_y;
    static WSCushort _pixmap_w;
    static WSCushort _pixmap_h;
    static WSCushort _copy_pixmap_w;
    static WSCushort _copy_pixmap_h;

    unsigned _use_pixmap_:1;
    unsigned _expose_sequence_bak:1;
    unsigned _expose_sequence_ch:1;

    static void getBackXY(short*,short*);
    static void getPixmapWH(WSCushort*,WSCushort*);
    static void getCopyPixmapGeom(short*,short*,WSCushort*,WSCushort*);

    virtual long _copy_pixmap_to_window()=0;

  public: 
    WSDnwDev();

    void    setUsePixmap(WSCbool fl);
    WSCbool getUsePixmap();

    virtual long cancelEvent(WSDdev* dev);

    virtual long setEventOrder(WSDdev* dev,char top_or_bottom);
    virtual long setEvent(WSDdev* dev,WSCbool on_off);
    virtual long setEnableEvent(long ev_kind);
    virtual long setEnableEventBit(long ev_bit);
    virtual long setDisableEvent(long ev_kind);
    virtual long setValue(long kind,void* value);
    virtual long setAbsoluteAddrChangeHandler(void(*)(WSDdev*,void*),void*);

    virtual long beginDraw(short,short,WSCushort,WSCushort,WSCbool absolute,WSCbool scaling = True);
    virtual long endDraw();
    virtual long exposeArea(long,long,WSCulong,WSCulong,WSCbool scaling = True);
    virtual long clearArea(long,long,WSCulong,WSCulong,WSCbool ,WSCbool scaling = True);

    virtual void getAbsoluteAddr(short,short,short*,short*);
    virtual void getDispAddr(short*,short*);
    virtual long getAvailableEventBit();
    virtual long getDeviceResource();
    virtual long getWindowResource();
    virtual long getContextResource();
    virtual long getSpecialResource();

    virtual WSCbool getReady();
    virtual WSCbool isAvailableEvent(long ev_kind);
    virtual long copyArea(long,long,WSCulong,WSCulong,long,long);

    WSMFclassDef(WSDnwDev,WSDdev);
};
#endif //WSDNWDEV_H
