/*-------------------------------------------------------------------------*/
/*  J3W ver 6.40  3D Animation Kit                                         */
/*  screen.h      11/22/97                                                 */
/*  Copyright (C) 1995 - 1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_screen_h)
#define _screen_h

#include "misc3d.h"

class TScreen {
  protected:
    int       range_y;
    int       range_x;
    int       height;
    int       width;
    int       top;
    int       left;
    int       max_color;
    int       old_mode;
    int       mode;
    int       BG_Color;

  public:
    TScreen() { width = 640; height = 480; top = 0; left = 0; mode = 0; }
    inline int  set_height(int h);
    inline int  set_width(int w);
    inline int  set_top(int t);
    inline int  set_left(int l);
    inline void set_BG_Color(int col);
    int  get_height(){return height;};
    int  get_width() {return width;};
    int  get_top()   {return top;};
    int  get_left()  {return left;};
    int  get_max_color() { return max_color;};
    virtual int  set_mode(int mode)=0;
    virtual void restore_mode()=0;
    virtual void update() = 0;
    virtual void clear() = 0;
    virtual int  line(Vector2D p1, Vector2D p2, int color)=0;
    virtual int  point(Vector2D p, int color) = 0;
    virtual int  polygon(Vector2D *vp, int vn, int color) = 0;

    virtual int  write_text(int x, int y, int col, char * text)  = 0;

    virtual void SetPaletteEntry(int n, int r , int g, int b) = 0;
    virtual void UpdatePalette() = 0;
};

inline int  TScreen::set_height(int h) {
    if (h < range_y) height = h;
    return h < range_y;
}

inline int  TScreen::set_width(int w) {
    if (w < range_x) width = w;
    return w < range_x;
}

inline int  TScreen::set_top(int t) {
    if (t < range_y) top = t;
    return t < range_y;
}

inline int  TScreen::set_left(int l) {
    if (l < range_x) left = l;
    return l < range_x;
}

inline void  TScreen::set_BG_Color(int col) {
    BG_Color = col;
}

#endif

