/*-------------------------------------------------------------------------*/
/*  J3W ver 6.41 3D Animation Kit                                          */
/*  scrnx.h        7/ 8/2000                                               */
/*  Copyright (C) 1997 - 2000 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_scrnx_h)
#define _scrnx_h

#ifndef WS
#define WS
#endif //WS

#ifdef WS
#include <WScom.h>
#include <WSDmwindowDev.h>
#include <WSDcolor.h>
#else
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif //WS

#include "screen.h"

const int PSEUDOCOLOR = 0;
const int TRUECOLOR   = 1;

class ScrnX : public TScreen {
    int ncol;
#ifdef WS
    WSDcolor*  colors[256];
    WSDmwindowDev* _mdev;
    WSDdev* _dev;
#else
    XColor  col[256];
    Display *d;
    Window  w;
    Font    f;
    GC      gc;
    GC      gcf;
    Pixmap  p;
    Colormap    cmap;
#endif
    int color_mode;
    int     mode;
    unsigned long rshift;
    unsigned long gshift;
    unsigned long bshift;
    unsigned long rbits;
    unsigned long gbits;
    unsigned long bbits;
#ifdef WS
    void initialize();
    WSDcolor* SearchColor(long r, long g, long b);
    void SetColorMap();
    short _whiteid,_blackid;
#else
    XSetWindowAttributes attr;
    XStandardColormap *stdcmap;
    unsigned long black, white;
    void OpenX();
    void SetupColorInfo();
    void SetColorMap(Visual* vis);
    unsigned long SearchColor(long r, long g, long b);
#endif
  public:
    ScrnX();
    virtual ~ScrnX();
#ifdef WS
    void setDev(WSDdev*);
    long beginDraw();
    long endDraw();
#else
    Display *GetDisplay();
    Window  *GetWindow();
#endif
    virtual int  set_mode(int mode);
    virtual void restore_mode();
    virtual void update();
    virtual void clear();
    virtual int  line(Vector2D p1, Vector2D p2, int color);
    virtual int  line_rgb(Vector2D p1, Vector2D p2, int r, int g, int b);
    virtual int  point(Vector2D p, int color);
    virtual int  polygon(Vector2D *vp, int vn, int color);
    virtual int  write_text(int x, int y,int color, char* text);
    virtual void SetPaletteEntry(int n, int r , int g, int b);
    virtual void UpdatePalette();
    int  polygon_rgb(Vector2D *vp, int vn, int r, int g, int b);
    int  GetColorMode() { return color_mode; };
};

#endif

