/*-------------------------------------------------------------------------*/
/*  J3W ver 6.43  3D Animation Kit                                         */
/*  spaceh3d.h   4/24/2001                                                 */
/*  Copyright (C) 1996 - 2001  Jun Mizutani <mizutani.jun@nifty.ne.jp>     */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_spaceh3d_h)
#define _spaceh3d_h

#include  "scrnx.h"
#include  "hobj3d.h"
#include  "misc3d.h"
#include  "pal256.h"

const int  MAXVERTEX = 10000;
const int  MAXPOLYGON = 10000;
const int  MAX2DVERTEX = 20000;
const int  POLYGONVERTEX = 24;

const double HIGHLIGHT = 0.2;
const int    POWER = 60;

struct ClipType {
    long kx,ky,kz,m;
};

struct PolygonType {
    int    n;
    int    color;
    unsigned int r;
    unsigned int g;
    unsigned int b;
    double reflection;
    double ambient;
    long   off_center;
    int    index;
    Vector center_g;
};

class TSpaceH3D {
  ScrnX *PScreen;
  int  maxObj;
  int  ObjCount;
  THObj3D **ObjArray;
  THObj3D *pEye;
  THObj3D *pLight;
  Vector light_dir;
  int  parallel;
  int VertCount;
  Vector *ClippedVertex;
  PolygonType *pglist;
  int  pglistmax;
  Vector2D *Polygon2D;
  int  max2D;
  int  angle;
  int  ColorNum;
  int  Shade;
  int visible(Vector &p, ClipType &clip);
  void ClipLine(Vector &p1, Vector &p2, ClipType &clip, Vector &p);
  int  Clip_polygon(int n, Vector *polygon_in, Vector *polygon_out,
                    ClipType &clipEq);
  void Clip_volume(int &n, Vector *polygon1);
  void Clip3D_PolygonList();
  void Polygon3Dto2D();
  void DepthSort();
  void set_clipplane(long front, long back);
  int  get_vertex() { return VertCount; }
  void ShadePolygon();
public:
  TSpaceH3D(int objNo, long front, long back);
  ~TSpaceH3D();
  void set_angle(int a);
  void set_screen(ScrnX *sc) { PScreen = sc; }

  void set_eye(THObj3D *eye){ pEye = eye; };
  void SetLightObject(THObj3D *pl) { pLight = pl; }
  THObj3D *get_object(int i) { return ObjArray[i];}

  void delete_object(int n);
  void reset_space();
  int  append_object(int vn, int pn);

  int  append_child_object(int n, int vn, int pn);

  int  count_object() { return ObjCount;}
  int  count_vertex();
  int  count_polygon();
  void display(long delta);
  int  get_color() { return ColorNum; };
  int  get_shade() { return Shade; };
  void SetLightType(int pr) { parallel = pr; };
  void SetLightDirection(Vector dir) {
      if ((dir.x)&&(dir.y)&&(dir.z)) light_dir = dir; };
};

#endif
