//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDappDev.h>
#include <advance/WSCtriggerEditor.h>
#include <WSCbaseDialog.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSCvlabel.h>
#include <WSClist.h>
#include <WSCoption.h>
#include <WSCmessageDialog.h>
#include <WSCclassInformation.h>


#define WS_OLLD_TGRMENU    \
"NONE:-1:,ACTIVATE:2:,VALUE_CH:3:,FOCUS_CH:4:,VISIBLE_CH:5:,\
SENSITIVE_CH:6:,PARENT_VISIBLE_CH:7:,PARENT_SENSITIVE_CH:8:,\
EXPOSE:9:,RESIZE:10:,\
MOUSE_IN:11:,MOUSE_OUT:12:,MOUSE_PRESS:13:,MOUSE_RELEASE:14:,\
MOUSE_MOVE:15:,KEY_PRESS:16:,KEY_RELEASE:17:,KEY_HOOK:18"

WSMFguiClassInitialize(WSCtriggerEditor,WSCbaseDialog);

WSMFversion(WSCtriggerEditor,WSCbaseDialog);


void WSCtriggerEditor::_property_delete(){
  delAllProcedure();
}
WSMFproperty(WSCtriggerEditor,WSNreplyHandler,void*,_reply_hd,0);
void WSCtriggerEditor::setWorkWSNreplyHandler(void*){
}
void WSCtriggerEditor::getWorkWSNreplyHandler(void**){
}


void WSCtriggerEditor::_adjust(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (_w > 2){
    _trgsarea001->setPropertyV(WSNwidth,(WSCushort)(_w -2));
  }else{
    _trgsarea001->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (_w > 140){
	_trgslist008->setPropertyV(WSNwidth,(WSCushort)(_w - 140));
  }else{
	_trgslist008->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (_w > 45){
    _trgsarea001->setPropertyV(WSNheight,(WSCushort)(_h -45));
  }else{
    _trgsarea001->setPropertyV(WSNheight,(WSCushort)(1));
  }

  if (_h + diff > 55){
	_trgslist008->setPropertyV(WSNheight,(WSCushort)(_h +diff - 55));
  }else{
	_trgslist008->setPropertyV(WSNheight,(WSCushort)(1));
  }
}

WSMFproperty(WSCtriggerEditor,WSNclient,void*,_client,0);
void WSCtriggerEditor::setWorkWSNwidth(WSCushort val){
  WSCbaseDialog::setWorkWSNwidth(val);
  _adjust();
}
void WSCtriggerEditor::setWorkWSNheight(WSCushort val){
  WSCbaseDialog::setWorkWSNheight(val);
  _adjust();
}

void WSCtriggerEditor::onResize(WSCrect* area){
  WSCbaseDialog::onResize(area);
  _adjust();
}
long WSCtriggerEditor::initialize(){
    WSCbaseDialog::initialize();

  	setUserData(WS_BASE_CLASS,(void*)this);
	setPropertyV(WSNshadowThickness,(WSCuchar)1);
//	setPropertyV(WSNtitleBar,(char)WS_ONLY_TITLE);
	setPropertyV(WSNtitleString,"Trigger Setup");
	setPropertyV(WSNno,(WSCbool)False);
	setPropertyV(WSNokString,WSGFgettext("r3:WSSTR OK"));

	WSCprocedure* op_WSCtriggerEditor_0 = new WSCprocedure("visop",WSEV_VISIBLE_CH);
	op_WSCtriggerEditor_0->setFunction(visop,"visop");
	addProcedure(op_WSCtriggerEditor_0);

	_trgsarea001 = new  WSCform(this,"_trgsarea001");
	_trgsarea001->initialize();
	_trgsarea001->setInternalObject(True);
	_trgsarea001->setUserData(WS_BASE_CLASS,(void*)this);
	_trgsarea001->setPropertyV(WSNx,(short)1);
	_trgsarea001->setPropertyV(WSNy,(short)5);
	_trgsarea001->setPropertyV(WSNwidth,(WSCushort)398);
	_trgsarea001->setPropertyV(WSNheight,(WSCushort)155);
	_trgsarea001->setPropertyV(WSNshadowThickness,(WSCuchar)1);
	_trgsarea001->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
	_trgsarea001->setVisible(True);

	_trgslist008 = new  WSClist(_trgsarea001,"_trgslist008");
	_trgslist008->initialize();
	_trgslist008->setInternalObject(True);
	_trgslist008->setUserData(WS_BASE_CLASS,(void*)this);
	_trgslist008->setPropertyV(WSNx,(short)130);
	_trgslist008->setPropertyV(WSNy,(short)5);
	_trgslist008->setPropertyV(WSNwidth,(WSCushort)260);
	_trgslist008->setPropertyV(WSNheight,(WSCushort)145);
	_trgslist008->setPropertyV(WSNshadowThickness,(WSCuchar)1);
	_trgslist008->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
	_trgslist008->setVisible(True);

	_trgsopti009 = new  WSCoption(_trgsarea001,"_trgsopti009");
	_trgsopti009->initialize();
	_trgsopti009->setInternalObject(True);
	_trgsopti009->setUserData(WS_BASE_CLASS,(void*)this);
	_trgsopti009->setPropertyV(WSNshadowThickness,(WSCuchar)1);
	_trgsopti009->setPropertyV(WSNemboss,(WSCbool)1);
	_trgsopti009->setPropertyV(WSNx,(short)5);
	_trgsopti009->setPropertyV(WSNy,(short)5);
	_trgsopti009->setPropertyV(WSNwidth,(WSCushort)120);
	_trgsopti009->setPropertyV(WSNheight,(WSCushort)20);
	_trgsopti009->setVisible(True);

	WSCvbtn* trgsvbtn010 = new  WSCvbtn(_trgsarea001,"trgsvbtn010");
	trgsvbtn010->initialize();
	trgsvbtn010->setInternalObject(True);
	trgsvbtn010->setUserData(WS_BASE_CLASS,(void*)this);
	trgsvbtn010->setPropertyV(WSNshadowThickness,(WSCuchar)1);
	trgsvbtn010->setPropertyV(WSNlabelString,WSGFgettext("L3:WSSTR Add"));
	trgsvbtn010->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/tbtn2.xpm");
	trgsvbtn010->setPropertyV(WSNx,(short)5);
	trgsvbtn010->setPropertyV(WSNy,(short)30);
	trgsvbtn010->setPropertyV(WSNwidth,(WSCushort)60);
	trgsvbtn010->setPropertyV(WSNheight,(WSCushort)25);
	WSGFsetMargin(trgsvbtn010,0);
	WSCprocedure* op_trgsvbtn010_0 = new WSCprocedure("addop",WSEV_ACTIVATE);
	op_trgsvbtn010_0->setFunction(addop,"addop");
	trgsvbtn010->addProcedure(op_trgsvbtn010_0);
	trgsvbtn010->setVisible(True);

	WSCvbtn* trgsvbtn011 = new  WSCvbtn(_trgsarea001,"trgsvbtn011");
	trgsvbtn011->initialize();
	trgsvbtn011->setInternalObject(True);
	trgsvbtn011->setUserData(WS_BASE_CLASS,(void*)this);
	trgsvbtn011->setPropertyV(WSNshadowThickness,(WSCuchar)1);
	trgsvbtn011->setPropertyV(WSNlabelString,WSGFgettext("M3:WSSTR Delete"));
	trgsvbtn011->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/tbtn2.xpm");
	trgsvbtn011->setPropertyV(WSNx,(short)65);
	trgsvbtn011->setPropertyV(WSNy,(short)30);
	trgsvbtn011->setPropertyV(WSNwidth,(WSCushort)60);
	trgsvbtn011->setPropertyV(WSNheight,(WSCushort)25);
	WSGFsetMargin(trgsvbtn011,0);
	trgsvbtn011->setVisible(True);

	WSCprocedure* op_trgsvbtn011_0 = new WSCprocedure("delop",WSEV_ACTIVATE);
	op_trgsvbtn011_0->setFunction(delop,"delop");
	trgsvbtn011->addProcedure(op_trgsvbtn011_0);

  _msg = new WSCmessageDialog(this,"msg");
  _msg->initialize();
  _msg->setPropertyV(WSNx,(short)300);
  _msg->setPropertyV(WSNy,(short)300);
  _msg->setPropertyV(WSNwidth,(WSCushort)400);
  _msg->setPropertyV(WSNheight,(WSCushort)100);
  _msg->setPropertyV(WSNtitleString,"Warring");
  _msg->setPropertyV(WSNmodal,(WSCbool)True);

  setPropertyV(WSNwidth,(WSCushort)400);
  setPropertyV(WSNheight,(WSCushort)160);

//  _adjust();
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  return WS_NO_ERR;
}
void WSCtriggerEditor::onActivate(){
  WSCbaseDialog::onActivate();
  long fl = getStatus();
  if (fl == WS_DIALOG_OK){
    WSCbase* client = (WSCbase*)_client;
    if (client != NULL){
      WSClistData* tlist = (WSClistData*)client->getUserData(WS_TRG_LIST);
      if (tlist == NULL){
        tlist = new WSClistData();
        client->setUserData(WS_TRG_LIST,(void*)tlist);
      }
      tlist->clear();

      long num = _trgslist008->getNum();
      long i;
      for(i=0; i <num; i++){
        char* ev = _trgslist008->getItem(i);
        if (client->existTrigger(WSGFnameToEvent(ev)) == False){
          tlist->add((void*)WSGFnameToEvent(ev));
        }
      }
      WSGFmarkChanged(client);
    }
    setVisible(False);
  }
}




WSCtriggerEditor::WSCtriggerEditor(WSCbase* base,char* objName):
WSCtriggerEditorBASETYPE(base,objName){
  _msg = NULL;
  _trgsarea001 = NULL;
  _trgslist008 = NULL;
  _trgsopti009 = NULL;
  _reply_hd = NULL;
  _client = NULL;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCtriggerEditor);
    WSMFpropertyCreate(WSNreplyHandler,void*,_reply_hd,WSSreplyHandler);
    WSMFpropertyCreate(WSNclient,void*,_client,WSSclient);
  WSMFpropertyCreateEnd
}

WSCtriggerEditor::~WSCtriggerEditor(){

  _property_delete();
  //򵭽ҤƤ


}


void WSCtriggerEditor::setWorkWSNclient(void* data){
  WSCbase* client = (WSCbase*)data;
  if (_trgslist008 != NULL){
    _trgslist008->delAll();
    if (client != NULL){
      long i;
      WSClistData* tlist = (WSClistData*)client->getUserData(WS_TRG_LIST);
      if (tlist == NULL){
        tlist = new WSClistData();
        client->setUserData(WS_TRG_LIST,(void*)tlist);
      }
      long num = tlist->getNum();
      for(i=0; i <num; i++){
        long ev = (long)(*tlist)[i];
        _trgslist008->addItem(WSGFeventToName(ev),-1);
        WSCbase* label = _trgslist008->getLabel(-1);
        label->setUserData("fixed",(void*)0);
      }
      for(i=0; i<WSEV_HASH_MAX_NUM; i++){
        if (client->existTrigger(i)){
          _trgslist008->addItem(WSGFeventToName(i),-1);
          WSCbase* label = _trgslist008->getLabel(-1);
          label->setPropertyV(WSNforeColor,"#0000ff");
          label->setUserData("fixed",(void*)1);
        }
      }
    }
    _trgslist008->updateList();
    _trgslist008->draw();
  }
}

void WSCtriggerEditor::getWorkWSNclient(void**){
}
void WSCtriggerEditor::addop(WSCbase* object){
  WSCtriggerEditor* base = (WSCtriggerEditor*)object->getUserData(WS_BASE_CLASS);
  long val;
  base->_trgsopti009->getPropertyV(WSNvalue,&val);
  if (val == WSEV_NONE){
    return;
  }
  void*     cl;
  base->getPropertyV(WSNclient,&cl);
  WSCbase* client = (WSCbase*)cl;
  if (client != NULL && client->existTrigger(val) != False){
    base->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
    base->_msg->setPropertyV(WSNlabelString,WSGFgettext("z3:WSSTR This trigger already exists."));
    base->_msg->setVisible(True);
    return; 
  }

  char* item = WSGFeventToName(val);
  long num = base->_trgslist008->getNum();
  long i;
  WSCbool fl = False;
  for(i=0; i<num; i++){
    if (!strcmp(base->_trgslist008->getItem(i),item)){
      fl = True;
      break;
    } 
  }
  if (fl == False){
    base->_trgslist008->addItem(WSGFeventToName(val),-1);
  }else{
    base->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
    base->_msg->setPropertyV(WSNlabelString,WSGFgettext("A3:WSSTR This trigger already exists."));
    base->_msg->setVisible(True);
  }
  base->_trgslist008->updateList();
  base->_trgslist008->draw();
}

void WSCtriggerEditor::delop(WSCbase* object){
  WSCtriggerEditor* base = (WSCtriggerEditor*)object->getUserData(WS_BASE_CLASS);
  long pos = base->_trgslist008->getSelectedPos();
  if (pos > -1){
    WSCbase* lb = base->_trgslist008->getLabel(pos);
    if ((long)lb->getUserData("fixed") == 0){
      base->_trgslist008->delPos(pos);
      base->_trgslist008->updateList();
      base->_trgslist008->redraw();
    }else{
      base->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
      base->_msg->setPropertyV(WSNlabelString,WSGFgettext("B3:WSSTR Can not delete the fixed trigger."));
      base->_msg->setVisible(True);
    }
  }else{
    base->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
    base->_msg->setPropertyV(WSNlabelString,WSGFgettext("C3:WSSTR Please select a trigger to delete."));
    base->_msg->setVisible(True);
  }
}

void WSCtriggerEditor::visop(WSCbase* object){
  WSCtriggerEditor* base = (WSCtriggerEditor*)object->getUserData(WS_BASE_CLASS);
  if (base->getVisible() == False){
    return;
  }

  base->_trgsopti009->setPropertyV(WSNmenuItems,WS_OLLD_TGRMENU);
  base->_trgsopti009->setPropertyV(WSNvalue,(long)-1);
  base->_trgsopti009->redraw();

  void* client;
  base->getPropertyV(WSNclient,&client);
  base->setPropertyV(WSNclient,(void*)NULL);
  base->setPropertyV(WSNclient,client);
}

WSClist* WSCtriggerEditor::getList(){
  return _trgslist008;
}

void WSCtriggerEditor::onGuiPolicyChange(long policy){
  if (_trgsarea001 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _trgsarea001->setProperty(WSNy,5);
      _trgsarea001->setProperty(WSNshadowThickness,1);
    }else{
      _trgsarea001->setProperty(WSNy,0);
      _trgsarea001->setProperty(WSNshadowThickness,0);
    }
    _adjust();
  }
}
