//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCdialog.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvlabel.h>
#include <WSCvbtn.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCdialog,WSCbaseDialog);
WSMFversion(WSCdialog,WSCbaseDialog);

#define D_BTN_WIDTH 80
//WSMFpropertyValueChange(WSCdialog,WSNno,WSCbool,False);

WSCdialog::WSCdialog(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){
  _area1 = NULL;
  _dev_is_public_dev = True;
  _wbg_no = WS_DF_DARKBACKCOLOR;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCdialog);

    WSMFpropertyCreate(WSNworkBackColor,  short, _wbg_no,WSSworkBackColor );
    WSMFpropertyDelete(WSNshadowThickness);


  WSMFpropertyCreateEnd
}

WSCdialog::~WSCdialog(){
}


WSMFproperty(WSCdialog, WSNworkBackColor,short, _wbg_no ,WS_DF_DARKBACKCOLOR);

void WSCdialog::setWorkWSNworkBackColor(short no){
  if (_area1 != NULL){
    _area1->setProperty(WSNbackColor,no);
  }
}
void WSCdialog::getWorkWSNworkBackColor(short* ){}



long WSCdialog::initialize(){
  WSCbaseDialog::initialize();
  _area1 = new WSCform(this,"md-label");
  _area1->setInternalObject(True);
  _area1->setUseParentBaseDev(True);
  _area1->initialize();
  _area1->setInternalObject(True);
  _area1->setPropertyV(WSNx,     (short)0 );
  _area1->setPropertyV(WSNy,     (short)5 );
//  _area1->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _area1->setPropertyV(WSNbackColor,WSGFcolor("gray80"));

  _area1->setProperty(WSNbackColor,_wbg_no);
//  _area1->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
  _area1->setVisible(True);
  _dev_public = _area1;

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  return WS_NO_ERR;
}

void WSCdialog::adjustForm(){
  WSCbaseDialog::adjustForm();
  if(_area1 != NULL){
    long diff = 0;
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      diff = 0;
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      diff = 5;
    }
    if (_w > 2){
      _area1->setPropertyV(WSNwidth, (WSCushort)(_w));
    }else{
      _area1->setPropertyV(WSNwidth, (WSCushort)(1));
    }
    if (_h +diff > 45){
      _area1->setPropertyV(WSNheight,(WSCushort)(_h +diff - 45));
    }else{
      _area1->setPropertyV(WSNheight,(WSCushort)(1));
    }
  }  
}

void WSCdialog::onGuiPolicyChange(long policy){
  if (_area1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _area1->setProperty(WSNy,5);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _area1->setProperty(WSNy,0);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    }
    adjustForm();
  }
}

