//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDsocket.h>

WSMFclassInit(WSDsocket,WSCroot);

WSDsocket::WSDsocket(){
  _port = 0; 
  _addr = 0; 
  _dest_addr = 0; 
  _started_accept = False;
  _stop_accept = False;
  _user_data = NULL;
  _timeout = 0;
  _cl_timeout = 0;
  _udp = False;
  _udp_binded = False;
}

WSDsocket::~WSDsocket(){
  destroy();
}

long WSDsocket::destroy(){
  return WS_NO_ERR;
}
void WSDsocket::setTimeout(WSCulong timeout){
  _timeout = timeout;
}
void WSDsocket::setClTimeout(WSCulong timeout){
  _cl_timeout = timeout;
}
WSCulong WSDsocket::getTimeout(){
  return _timeout;
}
WSCulong WSDsocket::getClTimeout(){
  return _cl_timeout;
}


long WSDsocket::setAddr(char* naddr){
  destroy();
  _naddr = naddr;
  return WS_NO_ERR;
}

long WSDsocket::setDestAddr(char* addr){
  destroy();
  _dest_naddr = addr;
  return WS_NO_ERR;
}

long WSDsocket::setPort(WSCushort port){
  destroy();
  _port = port;
  return WS_NO_ERR;
}
long WSDsocket::setDestPort(WSCushort port){
  destroy();
  _dest_port = port;
  return WS_NO_ERR;
}


WSCushort WSDsocket::getPort(){
  return _port;
}

WSCushort WSDsocket::getDestPort(){
  return _dest_port;
}

WSCstring WSDsocket::getAddr(){
  return _naddr;
}
WSCstring WSDsocket::getDestAddr(){
  return _dest_naddr;
}

long WSDsocket::initialize(){
  return WS_NO_ERR;
}
long WSDsocket::connect(){
fprintf(stderr,"WSDsocket::connet(): this version does not support connect().\n");
  return WS_ERR;
}
void* WSDsocket::accept(){
fprintf(stderr,"WSDsocket::accept(): this version does not support accept().\n");
  return NULL;
}
long WSDsocket::acceptEx(void(*)(WSDsocket*,void*,WSCulong)){
fprintf(stderr,"WSDsocket::accept(): this version does not support acceptEx().\n");
  return WS_ERR;
}

long WSDsocket::stopAcceptEx(){
  _stop_accept = True;
  return WS_NO_ERR;
}
long WSDsocket::close(void*){
fprintf(stderr,"WSDsocket::close(): this version does not support close().\n");
  return WS_ERR;
}
long WSDsocket::listen(){
fprintf(stderr,"WSDsocket::listen(): this version does not support listen().\n");
  return WS_ERR;
}
long WSDsocket::read(void* handle,WSCuchar* buffer,long size){
fprintf(stderr,"WSDsocket::read(): this version does not support read().\n");
  return -1;
}
long WSDsocket::write(void* handle,WSCuchar* buffer,long size){
fprintf(stderr,"WSDsocket::write(): this version does not support write().\n");
  return -1;
}
long WSDsocket::read(WSCuchar* buffer,long size){
fprintf(stderr,"WSDsocket::read(): this version does not support read().\n");
  return -1;
}
long WSDsocket::write(WSCuchar* buffer,long size){
fprintf(stderr,"WSDsocket::write(): this version does not support write().\n");
  return -1;
}

void WSDsocket::setCreateHandler(WSDsocket*(*hd)()){
  _chandler = hd;
}
WSDsocket* (*WSDsocket::_chandler)() = NULL;
WSDsocket* WSDsocket::getNewInstance(){
//printf("WSDsocket::getNewInstance _chandler=0x%x\n",_chandler);
  if (_chandler == NULL){
    return new WSDsocket;
  }
  return _chandler();
}
WSCbool WSDsocket::getAcceptStarted(){
  return _started_accept;
}
void WSDsocket::setUserData(void* ptr){
  _user_data = ptr;
}
void* WSDsocket::getUserData(){
  return _user_data;
}

void WSDsocket::setIsUdp(WSCbool fl){
  _udp = fl;
}

WSCbool WSDsocket::getIsUdp(){
  return _udp;
}
long WSDsocket::_continue_udp_read_accept(){
fprintf(stderr,"WSDsocket::_continue_udp_read_accept(): this version does not support _continue_udp_read_accept().\n");
  return WS_ERR;
}
//WSCulong WSDsocket::getDestAddrL(){
//  return _dest_addr;
//}
void WSDsocket::_set_dest_addr_(WSCulong addr){
  WSCuchar val1;
  WSCuchar val2;
  WSCuchar val3;
  WSCuchar val4;
  val1 = 0xff & addr;
  val2 = (0xff00 & addr)>>8;
  val3 = (0xff0000 & addr)>>16;
  val4 = (0xff000000 & addr)>>24;
  char buffer[32];
  sprintf(buffer,"%d.%d.%d.%d",val4,val3,val2,val1);
  _dest_naddr = buffer;
}
WSCstring WSDsocket::getLastError(){
  WSCstring tmp;
  return tmp;
}
