//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCverbList.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCsform.h>

WSMFguiClassInitialize(WSCverbList, WSClist);
WSMFversion(WSCverbList, WSClist);

WSMFpropertyValueChange( WSCverbList, WSNtype , WSCuchar,WS_VERBOSE);
WSMFpropertyValueChange( WSCverbList, WSNuseIcon , WSCbool,True);
WSMFpropertyValueChange( WSCverbList, WSNiconPixmap , short,WSGIappImageSet()->getImageNo("$(WSDIR)/sys/pixmaps/bi17.xpm"));
WSMFpropertyValueChange( WSCverbList, WSNtitleHeight , WSCuchar,20);

WSCverbList::WSCverbList(WSCbase* base, char* objname):
			WSClist(base, objname){

  _icon_pixmap = WSGIappImageSet()->getImageNo("$(WSDIR)/sys/pixmaps/bi17.xpm");
  _disp_type = WS_VERBOSE;
  _use_icon = True;
  _padding = 20;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCverbList);

    WSMFpropertyValueChangeDef( WSCverbList,WSNtype ,WSCuchar);
    WSMFpropertyValueChangeDef( WSCverbList,WSNuseIcon ,WSCbool);
    WSMFpropertyValueChangeDef( WSCverbList,WSNiconPixmap ,short);
    WSMFpropertyValueChangeDef( WSCverbList,WSNtitleHeight ,WSCuchar);
    WSMFpropertyVisibleOff( WSNtype );

  WSMFpropertyCreateEnd

}

WSCverbList::~WSCverbList() {
}
long WSCverbList::initialize(){
  long ret = WSClist::initialize();

  WSCstring name;
  name = (WSCstring)"sf-" + getInstanceName();
  _btn_area = new WSCsform(this,name);
  _btn_area->setInternalObject(True);
  _btn_area->setUseParentBaseDev(True);
  _btn_area->initialize();
  _btn_area->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _btn_area->setPropertyV(WSNbarThickness,(WSCushort)0);
  _btn_area->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  WSGFsetMargin(_btn_area,0);
  _adjust();
  if(_padding != 0){
    _btn_area->setVisible(True);
  }
  _btn_area->setUserData("p-list",(void*)this);
  WSCprocedure* op = new WSCprocedure("value-ch",WSEV_VALUE_CH);
  op->setInternal(True);
  op->setFunction(_btn_area_valuech,"_btn_area_valuech");
  _btn_area->addProcedure(op);

  return ret;
}
