//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvline.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCfontSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <ctype.h>

WSMFguiClassInitialize(WSCvline, WSCnwbase);
WSMFversion(WSCvline, WSCnwbase);

WSCvline::WSCvline(WSCbase* base, char* objname):
           WSCnwbase(base, objname){
  _lw = 2;
  _lt = 0;
  _data_x = WSGFstrdup("0,10,20,30,40,50,60,70,80,90,100");
  _data_y = WSGFstrdup("0,80,20,60,10,70,40,90,50,30,100");
  _line_num = 11;
  _line_x = new short[_line_num];
  _line_y = new short[_line_num];

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvline);

    WSMFparentCheckVerSrc(WSCnwbase);
    WSMFpropertyCreate(WSNlineWidth, WSCushort, _lw,WSSlineWidth);
    WSMFpropertyCreate(WSNlineType,  WSCuchar, _lt,WSSlineType);
      WSMFpropertySetSelection(WSRlineType, WSRlineTypeD);
    WSMFpropertyCreate(WSNlineX, char*, _data_x,WSSlineX );
    WSMFpropertyCreate(WSNlineY, char*, _data_y,WSSlineY );
    WSMFpropertyCreate(WSNlineNum, WSCuchar, _line_num,WSSlineNum);

    WSMFdelTrigger(WSEV_MOUSE_IN    );
    WSMFdelTrigger(WSEV_MOUSE_OUT   );
    WSMFdelTrigger(WSEV_MOUSE_MOVE  );
    WSMFdelTrigger(WSEV_MOUSE_PRESS   );
    WSMFdelTrigger(WSEV_MOUSE_RELEASE );

  WSMFpropertyCreateEnd

  _str_to_addr(_data_x, _line_x,_line_num);
  _str_to_addr(_data_y, _line_y,_line_num);

}
WSMFproperty(WSCvline, WSNlineWidth, WSCushort, _lw, 2);
WSMFproperty(WSCvline, WSNlineType,  WSCuchar,      _lt, 0);
WSMFproperty(WSCvline, WSNlineX,char*, _data_x,WSGFstrdup("0,10,20,30,40,50,60,70,80,90,100"));
WSMFproperty(WSCvline, WSNlineY,char*, _data_y,WSGFstrdup("0,80,20,60,10,70,40,90,50,30,100"));
WSMFproperty(WSCvline, WSNlineNum, WSCuchar, _line_num, 11);

void WSCvline::setWorkWSNlineWidth(WSCushort){}
void WSCvline::getWorkWSNlineWidth(WSCushort*){}
void WSCvline::setWorkWSNlineType(WSCuchar){}
void WSCvline::getWorkWSNlineType(WSCuchar*){}

void WSCvline::setWorkWSNlineX(char* data){
  if (data[0] != 0 && _line_x != 0) {
    _str_to_addr(data, _line_x,_line_num);
  }
}

void WSCvline::getWorkWSNlineX(char**){}

void WSCvline::setWorkWSNlineY(char* data){
  if (data[0] != 0 && _line_y != 0) {
    _str_to_addr(data, _line_y,_line_num);
  }
}

void WSCvline::getWorkWSNlineY(char**){}

void WSCvline::setWorkWSNlineNum(WSCuchar num){
  _set_data_num(num);
}

void WSCvline::getWorkWSNlineNum(WSCuchar*){}


WSCvline::~WSCvline(){
  if (_line_x != 0) {
    delete _line_x;
  }
  if (_line_y != 0) {
    delete _line_y;
  }
  delete _data_x;
  delete _data_y;
}

long WSCvline::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }

  WSDdev*	dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

//  short          x, y;
//  WSCushort w, h;
//  getGeometry(&x, &y, &w, &h);
  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == True){
  }else
  if (dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }

  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);
  if (_bl_fl == True &&
      blinkfore == True &&
      _tw_fl == False){
    return WS_NO_ERR;
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);

  WSCushort line_w = _lw;
  if (line_w != 0) {
    if (_bl_fl == True &&
        blinkfore == True &&
        _tw_fl == True){
      dev->setForeColor(_blink_color);
    } else {
      dev->setForeColor(_fore_color);
    }

    if (line_w == 1) {
      dev->setLineWidth((WSCushort)0);
    } else {
      dev->setLineWidth((WSCushort)line_w);
    }
    dev->setLineDashType(_lt);

    if (_line_num != 0) {
      WSCpoint* pt = new WSCpoint[_line_num];
      short	i;
      for (i=0; i<_line_num; i++) {
        pt[i].x = (short)(_line_x[i]);
        pt[i].y = (short)(_line_y[i]);
      }
      dev->drawLines(pt, _line_num);
      delete pt;
    }
  }
  dev->endDraw();

  return WS_NO_ERR;
}

long WSCvline::_set_data_num(short num) {
  long ret = WS_NO_ERR;

  if (num < 2) {
    return WS_ERR;
  }

  if (_line_x != 0) {
    delete _line_x;
  }
  if (_line_y != 0) {
    delete _line_y;
  }

  _line_num = num;

  _line_x = new short[num];
  _line_y = new short[num];

  for (short i = 0; i<num; i++) {
    _line_x[i] = _line_y[i] = 0;
  }

  // ɸ
  if (_data_x != 0) {
    _str_to_addr(_data_x, _line_x,_line_num);
  }
  if (_data_y != 0) {
    _str_to_addr(_data_y, _line_y,_line_num);
  }

  return (ret);
}
long WSCvline::_str_to_addr(char* str, short* data ,short num) {
  char	buf[17];
  short	i = 0;
  short	j = 0;
  short	k = 0;

  if (data == 0) {
    return WS_ERR;
  }

  while (str[i] != '\0' && isdigit(str[i]) == 0) {
    i++;
  }

  while (str[i] != '\0') {
    while (isdigit(str[i]) != 0) {
      if (j<17) {
        buf[j] = str[i];
        j++;
        i++;
      }
    }
    buf[j] = '\0';
    if (k < num) {
      data[k] = (short)atoi(buf);
      k++;
      j = 0;
      while (str[i] != '\0' && isdigit(str[i]) == 0) {
        i++;
      }
    } else {
      return WS_NO_ERR;
    }
  }

  short	s;
  for (s=k; s<num; s++) {
    data[s] = 0;
  }
  return WS_NO_ERR;
}

