//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvspace.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCvspace, WSCngbase);
WSMFversion(WSCvspace, WSCngbase);

WSCvspace::WSCvspace(WSCbase* base, char* objname):
			WSCngbase(base, objname){
  _title_string.setString("-\n|\n|-Space-|\n|\n-");
  _ext = 0;
  _orientation = 0; //horizon

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvspace);

    WSMFpropertyCreate(WSNextension,  WSCbool,   _ext,WSSextension);
      WSMFpropertySetSelection(WSRbool1, WSRbool1D);

    WSMFpropertyCreate(WSNorientation,  WSCuchar, _orientation,WSSorientation);
      WSMFpropertySetSelection(WSRorientation, WSRorientationD);

  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvspace, WSNextension, WSCbool, _ext ,0);
WSMFproperty( WSCvspace, WSNorientation, WSCbool, _orientation ,0);
void WSCvspace::setWorkWSNextension(WSCbool){
  WSCbase* parent = getParent();
  if (parent != NULL){
    if (_ext != 0){
      if (parent->cast("WSCvertForm") == NULL){
        long val = (long)parent->getUserData("vspace-resize-work");
        if (val == 0){
          parent->setUserData("vspace-resize-work",(void*)1);
          WSCprocedure* resize_op = new WSCprocedure("resizeop",WSEV_RESIZE);
          resize_op->setInternal(True);
          resize_op->setFunction(_resize_work,"_resize_work");
          parent->addProcedure(resize_op);
          parent->execProcedure(WSEV_RESIZE);
          parent->redraw();
        }
      }
    }
  }
  if (_ext == 0){
    _title_string.setString("-\n|\n|-Space-|\n|\n-");
    _title_string.setString("-\n|\n|-Space-|\n|\n-");
  }else{
    if (_orientation == 0){
      _title_string.setString("<-Space->");
    }else{
      _title_string.setString("+\n|\nSpace\n|\n+");
    }
  }
};
void WSCvspace::getWorkWSNextension(WSCbool*){};
void WSCvspace::setWorkWSNorientation(WSCuchar){
  if (_ext == 0){
    _title_string.setString("-\n|\n|-Space-|\n|\n-");
    _title_string.setString("-\n|\n|-Space-|\n|\n-");
  }else{
    if (_orientation == 0){
      _title_string.setString("<-Space->");
    }else{
      _title_string.setString("+\n|\nSpace\n|\n+");
    }
  }
};
void WSCvspace::getWorkWSNorientation(WSCuchar*){};




void WSCvspace::_resize_work(WSCbase* form){
  _adjust(form,0);
  _adjust(form,1);
}

void WSCvspace::_adjust(WSCbase* form,WSCbool vert){
  WSClistData children = form->getChildren();
  WSClistData childlist;
  WSClistData childpos;
  long num = children.getNum();
  long i;

  char* wsnx = WSNy;
  char* wsny = WSNx;
  char* wsnwidth = WSNheight;
  char* wsnheight = WSNwidth;

  if (vert == False){
    wsnx = WSNx;
    wsny = WSNy;
    wsnwidth = WSNwidth;
    wsnheight = WSNheight;
  }

  WSCulong pwidth = form->getProperty(wsnwidth);
  WSCulong pheight = form->getProperty(wsnheight);
  long vspacenum = 0;
  WSCulong realwidth = 0;

  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getVisible() == False){
      continue;
    }
    if (child->cast("WSCgripHand") != NULL){
      continue;
    }
    WSCushort width = child->getProperty(wsnwidth);
    if (child->cast("WSCvspace") != NULL){
      if ((WSCbool)child->getProperty(WSNextension) != False &&
          (WSCuchar)child->getProperty(WSNorientation) == (WSCuchar)vert){
        vspacenum++;
        width = 0;
      }
    }
    if (child->getUseParentBaseDev() != False){
      continue;
    }
    realwidth += width;
    long cnum = childpos.getNum();
    long k;
    long val = child->getProperty(wsnx);

    for(k=0; k<cnum; k++){
      long tpos = (long)childpos[k];
      if (val < tpos){
        break;
      }
    }
    childlist.add((void*)child,k);
    childpos.add((void*)val,k);
  }
  if (vspacenum == 0){
    return;
  }
  num = childlist.getNum();
  WSCulong vspace_width = 1;
  if (pwidth > realwidth){
    vspace_width = ((pwidth - realwidth)/vspacenum);
  }
  for(i=num-1;i>-1; i--){
    WSCbase* child = (WSCbase*)childlist[i];
    if (child->cast("WSCvspace") != NULL){
      if ((WSCbool)child->getProperty(WSNextension) != False &&
          (WSCuchar)child->getProperty(WSNorientation) == (WSCuchar)vert){
        child->setProperty(wsnwidth,vspace_width);
        child->setProperty(wsnheight,pheight);
        child->setProperty(wsny,0);
      }
    }
  }
  long pos = 0;
  for(i=0;i<num; i++){
    WSCbase* child = (WSCbase*)childlist[i];
    long cw = child->getProperty(wsnwidth);
    child->setProperty(wsnx,pos);
    pos+= cw;
  }
}

