#include "IPServer.H"

//#include "LocalObj.H"
#include "wsocxppg.h"
#include "wsocxctl.h"
#include "Resource.h"
#include "Util.H"


// for ASSERT and FAIL
//
SZTHISFILE

//=--------------------------------------------------------------------------=
// Property Page messages
//=--------------------------------------------------------------------------=
// in addition to regular windows messages you'll receive for a dialog box,
// you'll receive the following messages in your property page implementation:
//
// PPM_NEWOBJECTS:
//    wParam = 0;
//    lParam = (LPARAM)(HRESULT *)hr
//
//  - in this message, you should call FirstControl() to get a pointer to a
//    control, and initialize the values in the property page dialog with
//    values from the control object.  put results from the operation in
//    the HRESULT pointed to by LPARAM.
//
// PPM_APPLY:
//    wParam = 0;
//    lParam = (LPARAM)(HRESULT *)hr
//
//  - this message is sent to your dialog whenever the user clicks APPLY or OK
//    in the dialog.  you should have a loop with the following code in it:
//
//      for (pUnk = FirstControl(&dwCookie) ; pUnk; pUnk = NextControl(&dwCookie)) {
//            hr = pUnk->QueryInterface(IID_IMyCtlInterface, (void **)&pMyCtl);
//            // set properties here!!!
//      }
//
//    call PropPageException() if there is an error while setting propertites
//    to show the exception set up by the property set routine.
//
// PPM_EDITPROPERTY:
//    wParam = dispid
//    lParam = (LPARAM)(HRESULT *)hr
//
//  - sent to your dialog when somebody wants you to set the focus to a specific
//    property [typically, one will see a call to this when one returns a page
//    from IPerPropertyBrowsing::MapPropertyToPage].  you can use this
//    to bring up dialogs, or do whatever flaps your flagella.
//


//=--------------------------------------------------------------------------=
// WSDocxGeneralPage::Create
//=--------------------------------------------------------------------------=
// global static creation function.
//
// Parameters:
//    IUnknown *    - [in] controlling unknown
//
// Output:
//    IUnknown *    - new prop page.
//
// Notes:
//
IUnknown *WSDocxGeneralPage::Create
(
    IUnknown *pUnkOuter
)
{
    return (IUnknown *)new WSDocxGeneralPage(pUnkOuter);
}

//=--------------------------------------------------------------------------=
// WSDocxGeneralPage::WSDocxGeneralPage
//=--------------------------------------------------------------------------=
// constructor.
//
// Parameters:
//    IUnknown *        - [in] controlling unknown.
//
// Notes:
//
WSDocxGeneralPage::WSDocxGeneralPage
(
    IUnknown *pUnkOuter
)
: CPropertyPage(pUnkOuter, OBJECT_TYPE_PPGWSOCXGENERAL)
{
    // initialize local variables here.
}

//=--------------------------------------------------------------------------=
// WSDocxGeneralPage::~WSDocxGeneralPage
//=--------------------------------------------------------------------------=
// destructor.
//
// Notes:
//
WSDocxGeneralPage::~WSDocxGeneralPage()
{
    // clean up
}

static int SimpleAtoi( const char *str )
{
	int num = 0;
	const char *s;

	for( s = (*str == '-' ? str+1 : str); *s >= '0' && *s <= '9'; s++ )
		num = num * 10 + (*s - '0');

	return( *str == '-' ? -num : num );
}

static void SetDropDown( HWND hwnd, const char *strs[], int id, short set )
{
	short newset;
	int i;

	newset = -1000;
	for( i = 0; strs[i]; i++ )
	{
		SendMessage( GetDlgItem( hwnd, id ), CB_ADDSTRING, 
			0, (LPARAM) strs[i] );
		if( SimpleAtoi(strs[i]) == set )
			newset = i;
	}
	if( newset != -1000 )
		SendMessage( GetDlgItem( hwnd, id ), CB_SETCURSEL,
				(WPARAM) newset, 0 );
}

//=--------------------------------------------------------------------------=
// WSDocxGeneralPage::DialogProc
//=--------------------------------------------------------------------------=
// our dialog proc.
//
// Parameters:
//    - see win32sdk docs on DialogProc
//
// Notes:
//
BOOL WSDocxGeneralPage::DialogProc
(
    HWND   hwnd,
    UINT   msg,
    WPARAM wParam,
    LPARAM lParam
)
{
#if 0
    HRESULT     hr;
    IWSocx *pWSocx;
    IUnknown   *pUnk;
    DWORD       dwDummy;
    enumWSocxNumber number;
    enumWSocxSuite suite;
    enumWSocxAlignment cardalignment;
	VARIANT_BOOL invert;

	static const char *numstr[] = {
		"1   - Ace",
		"2", "3", "4", "5", "6", "7", "8", "9", "10",
		"11  - Jack",
		"12  - Queen",
		"13  - King",
	        "14  - Joker",
		NULL };

	static const char *alignstr[] = {
		"0   - Top Left",
		"1   - Top Center",
		"2   - Top Right",
		"3   - Center Left",
		"4   - Center",
		"5   - Center Right",
		"6   - Bottom Left",
		"7   - Bottom Center",
		"8   - Bottom Right",
		"9   - Stretch",
		NULL };

	static const char *suitestr[] = {
		"0   - Invisible",
		"1   - Clubs", 
		"2   - Spades", 
		"3   - Hearts", 
		"4   - Diamonds",
		"-1  - WSocx Back: Weave 1",		
		"-2  - WSocx Back: Weave 2",		
		"-3  - WSocx Back: Robot",		
		"-4  - WSocx Back: Roses",		
		"-5  - WSocx Back: Vine 1 (black)",
		"-6  - WSocx Back: Vine 2 (blue)",		
		"-7  - WSocx Back: Fish 1 (light blue)",		
		"-8  - WSocx Back: Fish 2 (dark blue)",		
		"-9  - WSocx Back: Seashell",		
		"-10 - WSocx Back: Castel",
		"-11 - WSocx Back: Beach",
		"-12 - WSocx Back: Hand",
		"-13 - WSocx Back: Casino", 
		NULL };

    switch (msg) {

      // we've been given some new objects, so go and re-set up the dialog page.
      //
      case PPM_NEWOBJECTS:
        {

        pUnk = FirstControl(&dwDummy);
        if (!pUnk) return FALSE;

        hr = pUnk->QueryInterface(IID_IWSocx, (void **)&pWSocx);
        if (FAILED(hr)) return FALSE;

        pWSocx->get_Number(&number);
        pWSocx->get_Suite(&suite);
        pWSocx->get_Invert(&invert);
	pWSocx->get_WSocxAlignment(&cardalignment);

	SetDropDown( hwnd, suitestr, IDC_SUITE, suite );
	SetDropDown( hwnd, numstr, IDC_NUMBER, number );
	SetDropDown( hwnd, alignstr, IDC_ALIGNMENT, cardalignment );

	CheckDlgButton( hwnd, IDC_INVERT, invert == VARIANT_TRUE ? 1 : 0 );

        pWSocx->Release();
        }
        return TRUE;

      case PPM_APPLY:
        {
        char      szTmp[128];

        // get all the controls we have to update.
        //
        for (pUnk = FirstControl(&dwDummy) ; pUnk; pUnk = NextControl(&dwDummy)) 
		{
            hr = pUnk->QueryInterface(IID_IWSocx, (void **)&pWSocx);
            if (FAILED(hr)) continue;
    
            GetDlgItemText(hwnd, IDC_NUMBER, szTmp, 128);
	    number = (enumWSocxNumber) SimpleAtoi(szTmp);
            GetDlgItemText(hwnd, IDC_SUITE, szTmp, 128);
	    suite = (enumWSocxSuite) SimpleAtoi(szTmp);
            GetDlgItemText(hwnd, IDC_ALIGNMENT, szTmp, 128);
	    cardalignment = (enumWSocxAlignment) SimpleAtoi(szTmp);
	    invert = IsDlgButtonChecked( hwnd, IDC_INVERT ) ? VARIANT_TRUE : VARIANT_FALSE;
	    
            pWSocx->put_Number(number);
	    pWSocx->put_Suite(suite);
	    pWSocx->put_Invert(invert);
	    pWSocx->put_WSocxAlignment(cardalignment);
            pWSocx->Release();
        }
        }
        return TRUE;

      case WM_COMMAND:
        switch (LOWORD(wParam)) {
          case IDC_SUITE: case IDC_NUMBER: case IDC_ALIGNMENT:
            if (HIWORD(wParam) == CBN_SELCHANGE)
                MakeDirty();
	  case IDC_INVERT:
	    if( HIWORD(wParam) == BN_CLICKED )
		MakeDirty();
        }
        break;
    }

#endif
	return(FALSE);
}
